/* glpapi/glp_set_obj_coef.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_set_obj_coef - set objective function coefficient.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- void glp_set_obj_coef(LPI *lp, int j, double coef);
--
-- *Description*
--
-- The routine glp_set_obj_coef sets (changes) a coefficient of the
-- objective function at the j-th structural variable.
--
-- If the parameter j is zero, the routine sets (changes) the constant
-- term of the objective function. */

void glp_set_obj_coef(LPI *lp, int j, double coef)
{     if (!(0 <= j && j <= lp->n))
         fault("glp_set_obj_coef: j = %d; invalid column number", j);
      if (j == 0)
         lp->c0 = coef;
      else
         lp->col[j]->coef = coef;
      return;
}

/* eof */
