/* glpimg/set_viewport.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpimg.h"

/*----------------------------------------------------------------------
-- set_viewport - change view port.
--
-- *Synopsis*
--
-- #include "glpimg.h"
-- void set_viewport(IMG *img, int x1, int y1, int x2, int y2);
--
-- *Description*
--
-- The set_viewport routine sets the new view port of the raster image
-- which is a rectangle area with absolute coordinates (x1,y1) of the
-- left upper corner and (x2,y2) of the right lower corner. */

void set_viewport(IMG *img, int x1, int y1, int x2, int y2)
{     set_logorg(img, x1, y1);
      set_clipreg(img, x1, y1, x2, y2);
      return;
}

/* eof */
