/* glpimg/move_to.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpimg.h"

/*----------------------------------------------------------------------
-- move_to - change current point.
--
-- *Synopsis*
--
-- #include "glpimg.h"
-- void move_to(IMG *img, int x, int y);
--
-- *Description*
--
-- The move_to routine moves the current point of the raster image to
-- the new position with relative coordinates (x,y).
--
-- The current point may be placed out of image or clipping region. */

void move_to(IMG *img, int x, int y)
{     img->x = img->x0 + x;
      img->y = img->y0 + y;
      return;
}

/* eof */
