/* sample.c */

#include <stdio.h>
#include <stdlib.h>
#include "glpk.h"

int main(void)
{     double Z, x1, x2, x3;

s1:   glp_initialize();

s2:   glp_set_cpar("problem", "SAMPLE");

s3:   glp_create_item(GLP_COL, "x1");
s4:   glp_create_item(GLP_COL, "x2");
s5:   glp_create_item(GLP_COL, "x3");

s6:   glp_create_item(GLP_ROW, "Z");
s7:   glp_set_bounds(GLP_ROW, GLP_FR, 0.0, 0.0);
s8:   glp_find_item(GLP_COL, "x1"), glp_new_coef(10.0);
s9:   glp_find_item(GLP_COL, "x2"), glp_new_coef(6.0);
s10:  glp_find_item(GLP_COL, "x3"), glp_new_coef(4.0);

s11:  glp_create_item(GLP_ROW, "p");
s12:  glp_set_bounds(GLP_ROW, GLP_UP, 0.0, 100.0);
s13:  glp_find_item(GLP_COL, "x1"), glp_new_coef(1.0);
s14:  glp_find_item(GLP_COL, "x2"), glp_new_coef(1.0);
s15:  glp_find_item(GLP_COL, "x3"), glp_new_coef(1.0);

s16:  glp_create_item(GLP_ROW, "q");
s17:  glp_set_bounds(GLP_ROW, GLP_UP, 0.0, 600.0);
s18:  glp_find_item(GLP_COL, "x1"), glp_new_coef(10.0);
s19:  glp_find_item(GLP_COL, "x2"), glp_new_coef(4.0);
s20:  glp_find_item(GLP_COL, "x3"), glp_new_coef(5.0);

s21:  glp_create_item(GLP_ROW, "r");
s22:  glp_set_bounds(GLP_ROW, GLP_UP, 0.0, 300.0);
s23:  glp_find_item(GLP_COL, "x1"), glp_new_coef(2.0);
s24:  glp_find_item(GLP_COL, "x2"), glp_new_coef(2.0);
s25:  glp_find_item(GLP_COL, "x3"), glp_new_coef(6.0);

s26:  glp_set_ipar("obj_dir", GLP_MAX);
s27:  glp_set_cpar("obj_row", "Z");

s28:  glp_simplex();

s29:  glp_find_item(GLP_ROW, "Z");
s30:  glp_get_activity(GLP_ROW, NULL, &Z, NULL);
s31:  glp_find_item(GLP_COL, "x1");
s32:  glp_get_activity(GLP_COL, NULL, &x1, NULL);
s34:  glp_find_item(GLP_COL, "x2");
s35:  glp_get_activity(GLP_COL, NULL, &x2, NULL);
s36:  glp_find_item(GLP_COL, "x3");
s37:  glp_get_activity(GLP_COL, NULL, &x3, NULL);

s38:  printf("\nZ = %g; x1 = %g; x2 = %g; x3 = %g\n", Z, x1, x2, x3);

s39:  glp_terminate();

      return 0;
}

/* eof */
