/* glpstr/clear_str.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpstr.h"

/*----------------------------------------------------------------------
-- clear_str - clear segmented character string.
--
-- *Synopsis*
--
-- #include "glpstr.h"
-- STR *clear_str(STR *str);
--
-- *Description*
--
-- The clear_str routine makes the segmented character string str empty.
--
-- *Returns*
--
-- The clear_str routine returns a pointer to the string str. */

STR *clear_str(STR *str)
{     str->len = 0;
      while (str->head != NULL)
      {  SQE *sqe = str->head;
         str->head = sqe->next;
         free_atom(str->pool, sqe);
      }
      str->tail = NULL;
      return str;
}

/* eof */
