/* glpset/open_data.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <errno.h>
#include <stdio.h>
#include <string.h>
#include "glpset.h"

/*----------------------------------------------------------------------
-- open_data - open data stream.
--
-- *Synopsis*
--
-- #include "glpset.h"
-- DATA *open_data(char *fname);
--
-- *Description*
--
-- The open_data routine opens a data stream and connects it with an
-- input text file, whose name is the character string fname.
--
-- *Returns*
--
-- If the operation was successful, the routine returns a pointer to
-- the open data stream. Otherwise the routine returns NULL. */

DATA *open_data(char *fname)
{     DATA *ds;
      FILE *fp;
      fp = fopen(fname, "r");
      if (fp == NULL)
      {  error("open_data: unable to open `%s' - %s", fname,
            strerror(errno));
         return NULL;
      }
      ds = umalloc(sizeof(DATA));
      ds->fn = umalloc(strlen(fname)+1);
      strcpy(ds->fn, fname);
      ds->fp = fp;
      ds->cn = 0;
      return ds;
}

/* eof */
