/* glpprob/store_lpsol.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpk.h"
#include "glpprob.h"

/*----------------------------------------------------------------------
-- store_lpsol - store LP problem solution into the workspace.
--
-- *Synopsis*
--
-- #include "glpprob.h"
-- void store_lpsol(LPSOL *sol);
--
-- *Description*
--
-- The store_lpsol routine stores the LP problem basis solution which
-- the parameter sol points to, into the GLPK API workspace. */

void store_lpsol(LPSOL *sol)
{     int m, n, ret, status, kase;
      /* renumber and count rows */
      m = 0;
      for (ret = glp_first_item(GLP_ROW); ret == 0;
           ret = glp_next_item(GLP_ROW)) glp_set_seqn(GLP_ROW, ++m);
      /* renumber and count columns */
      n = 0;
      for (ret = glp_first_item(GLP_COL); ret == 0;
           ret = glp_next_item(GLP_COL)) glp_set_seqn(GLP_COL, ++n);
      /* check problem dimension */
      insist(sol->m == m && sol->n == n);
      /* set solution status */
      if (!sol->mipsol)
      {  switch (sol->status)
         {  case '?': status = GLP_UNDEF;  break;
            case 'O': status = GLP_OPT;    break;
            case 'F': status = GLP_FEAS;   break;
            case 'I': status = GLP_INFEAS; break;
            case 'N': status = GLP_NOFEAS; break;
            case 'U': status = GLP_UNBND;  break;
            default:  insist(sol->status != sol->status);
         }
      }
      else
      {  switch (sol->status)
         {  case 'O': status = GLP_INTOPT; break;
            case 'F': status = GLP_INTSOL; break;
            case 'I': status = GLP_DISINT; break;
            case 'N': status = GLP_NOINT;  break;
            default:  insist(sol->status != sol->status);
         }
      }
      glp_set_ipar("status", status);
      /* set values and reduced costs of variables */
      for (kase = 0; kase <= 1; kase++)
      {  int what = (kase == 0 ? GLP_ROW : GLP_COL);
         for (ret = glp_first_item(what); ret == 0;
              ret = glp_next_item(what))
         {  int k, seqn, tagx;
            glp_get_seqn(what, &seqn);
            k = (kase == 0 ? 0 : m) + seqn;
            insist(1 <= k && k <= m+n);
            switch (sol->tagx[k])
            {  case 'B': tagx = GLP_BS; break;
               case 'L': tagx = GLP_NL; break;
               case 'U': tagx = GLP_NU; break;
               case 'F': tagx = GLP_NF; break;
               case 'S': tagx = GLP_NS; break;
               default:  insist(sol->tagx[k] != sol->tagx[k]);
            }
            glp_set_activity(what, tagx, sol->valx[k], sol->dx[k]);
         }
      }
      /* return to the calling program */
      return;
}

/* eof */
