/* glpmip/btrack_lifo.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpmip.h"

/*----------------------------------------------------------------------
-- btrack_lifo - select active problem using LIFO heuristic.
--
-- *Synopsis*
--
-- #include "glpmip.h"
-- BBNODE *btrack_lifo(BBDATA *bb);
--
-- *Description*
--
-- The btrack_lifo routine selects an appropriate problem which should
-- be considered next from the active list.
--
-- *Returns*
--
-- The btrack_lifo routine returns a pointer to the problem node.
--
-- *Heuristic*
--
-- The btrack_lifo routine implements trivial LIFO (last-in-first-out)
-- heuristic, i.e. it selects the problem which was added to the active
-- list *after* any other problems. If this heuristic is used, the tree
-- is investigated in the depth-first-search manner. */

BBNODE *btrack_lifo(BBDATA *bb)
{     BBNODE *node;
      node = bb->last;
      insist(node != NULL);
      return node;
}

/* eof */
