/* glpeta/delete_eta.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpeta.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- delete_eta - delete eta-file.
--
-- *Synopsis*
--
-- #include "glpeta.h"
-- void delete_eta(HFILE *eta);
--
-- *Description*
--
-- The delete_eta routine deletes the eta-file freeing all memory that
-- was allocated to this object. */

void delete_eta(HFILE *eta)
{     delete_pool(eta->pool);
      ufree(eta);
      return;
}

/* eof */
