/* glpduff/exclude_obj.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpduff.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- exclude_obj - exclude object from Duff's scheme.
--
-- *Synopsis*
--
-- #include "glpduff.h"
-- void exclude_obj(DUFF *duff, int k);
--
-- *Description*
--
-- The exclude_obj routine excludes an object from the Duff's scheme.
-- The parameter k is the number of the excluded object. The object
-- should be in the scheme before exclusion. */

void exclude_obj(DUFF *duff, int k)
{     int len;
      if (!(1 <= k && k <= duff->n))
         fault("exclude_obj: invalid object number");
      len = duff->len[k];
      if (len < 0)
         fault("exclude_obj: object is not in the scheme");
      duff->len[k] = -1;
      if (duff->prev[k] == 0)
         duff->head[len] = duff->next[k];
      else
         duff->next[duff->prev[k]] = duff->next[k];
      if (duff->next[k] == 0)
         /* nop */;
      else
         duff->prev[duff->next[k]] = duff->prev[k];
      return;
}

/* eof */
