/* glpchol/solve_adat.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpchol.h"

/*----------------------------------------------------------------------
-- solve_adat - solve system A*D*A'*x = b using Cholesky factorization.
--
-- *Synopsis*
--
-- #include "glpchol.h"
-- void solve_adat(ADAT *adat, double x[], double work[]);
--
-- *Description*
--
-- The solve_adat routine obtains solution of the linear system S*x = b,
-- where S = A*D*A' is symmetric positive definite coefficient matrix,
-- A is rectangular matrix of full rank, D is diagonal matrix (assumed
-- to be non-singular), x is dense vector of unknowns, b is dense vector
-- of right-hand sides.
--
-- The parameter adat should specify Cholseky factorization of the
-- coefficient matrix S computed by means of the decomp_adat routine.
--
-- On entry the array x should contain elements of the vector b in
-- locations x[1], x[2], ..., x[m], where m is order of the system. On
-- exit this array will contain the vector x in the same locations.
--
-- The auxiliary array work should contain at least 1+m elements. If
-- this parameter is NULL, the routine automatically allocates and frees
-- the working array. */

void solve_adat(ADAT *adat, double x[], double work[])
{     solve_chol(adat->chol, x, work);
      return;
}

/* eof */
