/* glpavl/next_by_key.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpavl.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- next_by_key - search for the next node having same key in AVL-tree.
--
-- *Synopsis*
--
-- #include "glpavl.h"
-- AVLNODE *next_by_key(AVLTREE *tree, AVLNODE *node);
--
-- *Description*
--
-- The next_by_key routine searches the next node in the AVL-tree that
-- has the same key as the given node. (To perform this operation the
-- keys comparing routine should be defined.)
--
-- In order to find the first node that has the given key the routine
-- find_by_key can be used.
--
-- *Returns*
--
-- The next_by_key routine returns a pointer to the next node that has
-- the same key as the given node, or NULL if the next node does not
-- exist. */

AVLNODE *next_by_key(AVLTREE *tree, AVLNODE *node)
{     AVLNODE *p = node, *q;
      if (tree->comp == NULL)
         fault("next_by_key: keys comparing routine not defined");
      if (node == NULL)
         fault("next_by_key: node pointer not specified");
      q = p;
      p = next_node(tree, p);
      if (p != NULL) if (tree->comp(p->key, q->key) != 0) p = NULL;
      return p;
}

/* eof */
