/* glpapi/glp_next_item.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_next_item - find the next row or column.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- int glp_next_item(int what);
--
-- *Description*
--
-- If what = GLP_ROW, the glp_next_item routine finds the next row of
-- the problem, which follows the current row, and makes it be the
-- current row.
--
-- If what = GLP_COL, the glp_next_item routine finds the next column of
-- the problem, which follows the current column, and makes it be the
-- current column.
--
-- It's assumed that one row (column) precedes other row (column) if the
-- former was created before the latter. Hence, the next row (column) is
-- that one, which was created immediately after the current row
-- (column).
--
-- *Complexity*
--
-- The operation has time complexity O(1).
--
-- *Returns*
--
-- 0 - no errors;
-- 1 - the current row (column) is undefined or there is no the next row
--     (column) in the problem;
-- 2 - the parameter what is invalid. */

int glp_next_item(int what)
{     if (what == GLP_ROW)
      {  if (glp->this_row == NULL) return 1;
         glp->this_row = glp->this_row->next;
         if (glp->this_row == NULL) return 1;
      }
      else if (what == GLP_COL)
      {  if (glp->this_col == NULL) return 1;
         glp->this_col = glp->this_col->next;
         if (glp->this_col == NULL) return 1;
      }
      else
      {  /* invalid parameter */
         return 2;
      }
      return 0;
}

/* eof */
