/* glpapi/glp_get_kind.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_get_kind - get kind of the current row or column.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- int glp_get_kind(int what, int *kind);
--
-- *Description*
--
-- If what = GLP_ROW, the glp_get_kind routine stores the kind of the
-- current row to the location which kind points to.
--
-- If what = GLP_COL, the glp_get_kind routine stores the kind of the
-- current column to the location which kind points to.
--
-- GLP_NO means that the corresponding variable is continuous, GLP_YES
-- means that the corresponding variable is integer (discrete).
--
-- *Returns*
--
-- 0 - no errors;
-- 1 - the current row/column is undefined;
-- 2 - the parameter what is invalid. */

int glp_get_kind(int what, int *kind)
{     if (what == GLP_ROW)
      {  if (glp->this_row == NULL) return 1;
         *kind = (glp->this_row->kind == 0 ? GLP_NO : GLP_YES);
      }
      else if (what == GLP_COL)
      {  if (glp->this_col == NULL) return 1;
         *kind = (glp->this_col->kind == 0 ? GLP_NO : GLP_YES);
      }
      else
      {  /* invalid parameter */
         return 2;
      }
      return 0;
}

/* eof */
