/* glpstr/set_str.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <string.h>
#include "glpstr.h"

/*----------------------------------------------------------------------
-- set_str - assign value to segmented character string.
--
-- *Synopsis*
--
-- #include "glpstr.h"
-- STR *set_str(STR *str, char *from);
--
-- *Description*
--
-- The set_str routine copies data from the plain character string from
-- to the segmented character string str.
--
-- *Returns*
--
-- The set_str routine returns a pointer to the string str. */

STR *set_str(STR *str, char *from)
{     SQE *sqe;
      int len = strlen(from);
      char *ptr = from;
      clear_str(str);
      while (len > 0)
      {  int n = (len <= SQE_SIZE ? len : SQE_SIZE);
         sqe = get_atom(str->pool);
         memcpy(sqe->data, ptr, n);
         ptr += n, len -= n;
         sqe->next = NULL;
         str->len += n;
         if (str->head == NULL)
            str->head = sqe;
         else
            str->tail->next = sqe;
         str->tail = sqe;
      }
      return str;
}

/* eof */
