/* glpmat/create_per.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpmat.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- create_per - create permutation matrix.
--
-- *Synopsis*
--
-- #include "glpmat.h"
-- PER *create_per(int n);
--
-- *Description*
--
-- The create_per routine creates a permutation matrix of order n. The
-- created matrix initially is unity (identity) matrix.
--
-- *Returns*
--
-- The create_per returns a pointer to the created matrix. */

PER *create_per(int n)
{     PER *P;
      int k;
      if (n < 1)
         fault("create_per: invalid order");
      P = umalloc(sizeof(PER));
      P->n = n;
      P->row = ucalloc(1+n, sizeof(int));
      P->col = ucalloc(1+n, sizeof(int));
      for (k = 1; k <= n; k++) P->row[k] = P->col[k] = k;
      return P;
}

/* eof */
