/* glpapi/glp_check_name.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <ctype.h>
#include <string.h>
#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_check_name - check symbolic name for correctness.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- int glp_check_name(char *name);
--
-- *Description*
--
-- The glp_check_name routine checks the given symbolic name for
-- correctness.
--
-- The symbolic name is considered as correct if it contains from 1 up
-- to 255 arbitrary characters, except control and space characters.
--
-- *Returns*
--
-- 0 - the given symbolic name is valid;
-- 1 - the character string name has invalid length;
-- 2 - the character string name contains control or/and space
--     characters. */

int glp_check_name(char *name)
{     int len = strlen(name), k;
      if (!(1 <= len && len <= GLP_MAX_NAME)) return 1;
      for (k = 0; k < len; k++)
         if (iscntrl(name[k]) || name[k] == ' ') return 2;
      return 0;
}

/* eof */
