/* glpset/clear_pool.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpset.h"

/*----------------------------------------------------------------------
-- clear_pool - free all atoms.
--
-- *Synopsis*
--
-- #include "glpset.h"
-- void clear_pool(POOL *pool);
--
-- *Description*
--
-- The clear_pool routine frees all atoms borrowed from the specified
-- memory pool by means of the routines get_atom or get_atomv. Should
-- note that the clear_pool routine performs this operation moving all
-- allocated blocks to the list of free blocks, hence no memory will
-- be returned to the control program. */

void clear_pool(POOL *pool)
{     void *ptr;
      /* all allocated blocks are moved to the list of free blocks */
      while (pool->link != NULL)
      {  ptr = pool->link;
         pool->link = *(void **)ptr;
         *(void **)ptr = pool->stock;
         pool->stock = ptr;
      }
      pool->avail = NULL;
      pool->used = 0;
      pool->count = 0;
      return;
}

/* eof */
