/* glprsm/rsm_objval.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glprsm.h"

/*----------------------------------------------------------------------
-- rsm_objval - obtain current value of objective function.
--
-- *Synopsis*
--
-- #include "glprsm.h"
-- double rsm_objval(RSM *rsm);
--
-- *Returns*
--
-- The rsm_objval routine returns the current value of the original
-- objective function which is not scaled and has correct sign. */

double rsm_objval(RSM *rsm)
{     int obj = rsm->obj;
      double fun;
      if (obj == 0)
         fun = 0.0;
      else
      {  if (rsm->posx[obj] > 0)
            fun = rsm->bbar[+rsm->posx[obj]];
         else
            fun = rsm_get_xn(rsm, -rsm->posx[obj]);
         fun /= rsm->R[obj];
      }
      return fun;
}

/* eof */
