/* glprsm/rsm_check_dzeta.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <math.h>
#include "glprsm.h"

/*----------------------------------------------------------------------
-- rsm_check_dzeta - check accuracy of updated weights (dual).
--
-- *Synopsis*
--
-- #include "glprsm.h"
-- double rsm_check_dzeta(RSM *rsm);
--
-- *Description*
--
-- The rsm_check_dzeta routine returns maximal absolute difference
-- between the updated weights stored in the array dzeta and their
-- exact values computed by the routine rsm_exact_dzeta.
--
-- This operation is extermely inefficient, therefore it may be used
-- only for debugging purposes. */

double rsm_check_dzeta(RSM *rsm)
{     int m = rsm->m, i;
      double d, dmax = 0.0;
      for (i = 1; i <= m; i++)
      {  d = fabs(rsm->dzeta[i] - rsm_exact_dzeta(rsm, i));
         if (dmax < d) dmax = d;
      }
      return dmax;
}

/* eof */
