/* glpgel/create_lu.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpgel.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- create_lu - create LU-factorization.
--
-- *Synopsis*
--
-- #include "glpgel.h"
-- LU *create_lu(int n);
--
-- *Description*
--
-- The create_lu routine creates LU-factorization of order n. Initially
-- the created factorization corresponds to unity matrix.
--
-- *Returns*
--
-- The create_lu routine returns a pointer to the data structure that
-- represents LU-factorization of order n. */

LU *create_lu(int n)
{     LU *lu;
      int k;
      if (n < 1)
         fault("create_lu: invalid order");
      lu = umalloc(sizeof(LU));
      lu->n = n;
      lu->P = create_per(n);
      lu->L = create_mat(n, n);
      for (k = 1; k <= n; k++) new_elem(lu->L, k, k, 1.0);
      lu->U = create_mat(n, n);
      for (k = 1; k <= n; k++) new_elem(lu->U, k, k, 1.0);
      lu->Q = create_per(n);
      return lu;
}

/* eof */
