/*
 * Decompiled with CFR 0.152.
 */
package gnu.gleem;

import gl4java.GLFunc;
import gnu.gleem.HitPoint;
import gnu.gleem.Manip;
import gnu.gleem.ManipPart;
import gnu.gleem.ManipPartCube;
import gnu.gleem.ManipPartGroup;
import gnu.gleem.ManipPartLineSeg;
import gnu.gleem.ManipPartSquare;
import gnu.gleem.ManipPartTransform;
import gnu.gleem.ManipPartTwoWayArrow;
import gnu.gleem.linalg.IntersectionPoint;
import gnu.gleem.linalg.Line;
import gnu.gleem.linalg.Mat4f;
import gnu.gleem.linalg.MathUtil;
import gnu.gleem.linalg.Plane;
import gnu.gleem.linalg.PlaneUV;
import gnu.gleem.linalg.Rotf;
import gnu.gleem.linalg.Vec2f;
import gnu.gleem.linalg.Vec3f;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HandleBoxManip
extends Manip {
    private ManipPart parts = new ManipPartTwoWayArrow();
    private Vec3f translation = new Vec3f(0.0f, 0.0f, 0.0f);
    private Vec3f scale = new Vec3f(1.0f, 1.0f, 1.0f);
    private Vec3f geometryScale = new Vec3f(1.0f, 1.0f, 1.0f);
    private Rotf rotation = new Rotf();
    private Mat4f xform = new Mat4f();
    private static final int INACTIVE = 0;
    private static final int TRANSLATE = 1;
    private static final int ROTATE = 2;
    private static final int SCALE_XYZ = 3;
    private static final int SCALE_SINGLE_AXIS = 4;
    private int dragState = 0;
    private Plane dragPlane = new Plane();
    private Vec3f dragOffset = new Vec3f();
    private static final int SCALE_XY = 0;
    private static final int SCALE_YZ = 1;
    private static final int SCALE_ZX = 2;
    private ManipPart[] lineSegs = new ManipPart[12];
    private List faces = new ArrayList();
    private List highlightedGeometry = new ArrayList();
    private List draggedGeometry = new ArrayList();
    private List rotateHandles = new ArrayList();
    private PlaneUV rotatePlane = new PlaneUV();
    private float startAngle;
    private Rotf startRot = new Rotf();
    private int scaleAxes;
    private List scaleHandles = new ArrayList();
    private Line scaleXYZLine = new Line();
    private float origScaleLen;
    private Vec3f origScale = new Vec3f();
    private PlaneUV scaleAxisPlane = new PlaneUV();
    private Vec3f scaleAxisOffset = new Vec3f();
    private Vec2f scaleAxisOrigUV = new Vec2f();

    public HandleBoxManip() {
        this.createGeometry();
        this.recalc();
    }

    public void setTranslation(Vec3f translation) {
        this.translation.set(translation);
        this.recalc();
    }

    public Vec3f getTranslation() {
        return new Vec3f(this.translation);
    }

    public void setRotation(Rotf rotation) {
        this.rotation.set(rotation);
        this.recalc();
    }

    public Rotf getRotation() {
        return new Rotf(this.rotation);
    }

    public void setScale(Vec3f scale) {
        this.scale.set(scale);
        this.recalc();
    }

    public Vec3f getScale() {
        return new Vec3f(this.scale);
    }

    public void setGeometryScale(Vec3f geometryScale) {
        this.geometryScale.set(geometryScale);
        this.recalc();
    }

    public Vec3f getGeometryScale() {
        return new Vec3f(this.geometryScale);
    }

    public void render(GLFunc gl) {
        int i = 0;
        while (i < 12) {
            this.lineSegs[i].render(gl);
            ++i;
        }
        i = 0;
        while (i < this.rotateHandles.size()) {
            ((RotateHandleInfo)this.rotateHandles.get((int)i)).geometry.render(gl);
            ++i;
        }
        i = 0;
        while (i < this.scaleHandles.size()) {
            ((ScaleHandleInfo)this.scaleHandles.get((int)i)).geometry.render(gl);
            ++i;
        }
    }

    public void intersectRay(Vec3f rayStart, Vec3f rayDirection, List results) {
        Iterator iter = this.faces.iterator();
        while (iter.hasNext()) {
            ((FaceInfo)iter.next()).centerSquare.intersectRay(rayStart, rayDirection, results, this);
        }
        Iterator iter2 = this.rotateHandles.iterator();
        while (iter2.hasNext()) {
            ((RotateHandleInfo)iter2.next()).geometry.intersectRay(rayStart, rayDirection, results, this);
        }
        Iterator iter3 = this.scaleHandles.iterator();
        while (iter3.hasNext()) {
            ((ScaleHandleInfo)iter3.next()).geometry.intersectRay(rayStart, rayDirection, results, this);
        }
    }

    public void highlight(HitPoint hit) {
        ManipPart part = hit.manipPart;
        Iterator iter = this.faces.iterator();
        while (iter.hasNext()) {
            FaceInfo info = (FaceInfo)iter.next();
            if (info.centerSquare != part) continue;
            int j = 0;
            while (j < 4) {
                info.lineSegs[j].highlight();
                this.highlightedGeometry.add(info.lineSegs[j]);
                ++j;
            }
            return;
        }
        part.highlight();
        this.highlightedGeometry.add(part);
    }

    public void clearHighlight() {
        Iterator iter = this.highlightedGeometry.iterator();
        while (iter.hasNext()) {
            ((ManipPart)iter.next()).clearHighlight();
        }
        this.highlightedGeometry.clear();
    }

    public void makeActive(HitPoint hit) {
        Iterator iter = this.faces.iterator();
        while (iter.hasNext()) {
            FaceInfo face = (FaceInfo)iter.next();
            if (face.centerSquare != hit.manipPart) continue;
            this.dragState = 1;
            this.dragPlane.setPoint(hit.intPt.getIntersectionPoint());
            this.dragPlane.setNormal(face.normal);
            this.dragOffset.sub(this.translation, hit.intPt.getIntersectionPoint());
            int j = 0;
            while (j < 4) {
                face.lineSegs[j].highlight();
                this.draggedGeometry.add(face.lineSegs[j]);
                ++j;
            }
            return;
        }
        Iterator iter2 = this.rotateHandles.iterator();
        while (iter2.hasNext()) {
            float dotp1;
            RotateHandleInfo rotInfo = (RotateHandleInfo)iter2.next();
            if (rotInfo.geometry != hit.manipPart) continue;
            this.dragState = 2;
            float dotp0 = Math.abs(hit.rayDirection.dot(((FaceInfo)this.faces.get((int)rotInfo.faceIdx0)).normal));
            int faceIdx = dotp0 > (dotp1 = Math.abs(hit.rayDirection.dot(((FaceInfo)this.faces.get((int)rotInfo.faceIdx1)).normal))) ? rotInfo.faceIdx0 : rotInfo.faceIdx1;
            FaceInfo face = (FaceInfo)this.faces.get(faceIdx);
            this.rotatePlane.setOrigin(this.translation);
            this.rotatePlane.setNormal(face.normal);
            Vec3f dummy = new Vec3f();
            Vec2f startUV = new Vec2f();
            this.rotatePlane.projectPoint(hit.intPt.getIntersectionPoint(), dummy, startUV);
            this.startAngle = (float)Math.atan2(startUV.y(), startUV.x());
            this.startRot.set(this.rotation);
            rotInfo.geometry.highlight();
            this.draggedGeometry.add(rotInfo.geometry);
            return;
        }
        Iterator iter3 = this.scaleHandles.iterator();
        while (iter3.hasNext()) {
            ScaleHandleInfo info = (ScaleHandleInfo)iter3.next();
            if (info.geometry != hit.manipPart) continue;
            if (hit.shiftDown) {
                this.dragState = 4;
                float dotp = 0.0f;
                int faceIdx = 0;
                int i = 0;
                while (i < 3) {
                    FaceInfo faceInfo = (FaceInfo)this.faces.get(info.faceIndices[i]);
                    float tmpDotp = faceInfo.normal.dot(hit.rayDirection);
                    if (i == 0 || tmpDotp < dotp) {
                        dotp = tmpDotp;
                        faceIdx = info.faceIndices[i];
                    }
                    ++i;
                }
                this.scaleAxes = ((FaceInfo)this.faces.get((int)faceIdx)).scaleAxes;
                Vec3f uAxisOrig = new Vec3f();
                Vec3f vAxisOrig = new Vec3f();
                if (this.scaleAxes == 0) {
                    uAxisOrig.set(1.0f, 0.0f, 0.0f);
                    vAxisOrig.set(0.0f, 1.0f, 0.0f);
                } else if (this.scaleAxes == 1) {
                    uAxisOrig.set(0.0f, 1.0f, 0.0f);
                    vAxisOrig.set(0.0f, 0.0f, 1.0f);
                } else {
                    uAxisOrig.set(0.0f, 0.0f, 1.0f);
                    vAxisOrig.set(1.0f, 0.0f, 0.0f);
                }
                Vec3f uAxis = new Vec3f();
                Vec3f vAxis = new Vec3f();
                Mat4f rotationTmpMat = new Mat4f();
                rotationTmpMat.makeIdent();
                rotationTmpMat.setRotation(this.rotation);
                rotationTmpMat.xformDir(uAxisOrig, uAxis);
                rotationTmpMat.xformDir(vAxisOrig, vAxis);
                Vec3f normal = new Vec3f();
                normal.cross(uAxis, vAxis);
                this.scaleAxisPlane.setNormalAndUV(normal, uAxis, vAxis);
                Vec3f newOrigin = new Vec3f();
                Vec2f foo = new Vec2f();
                this.scaleAxisPlane.projectPoint(this.translation, newOrigin, foo);
                this.scaleAxisPlane.setOrigin(newOrigin);
                this.scaleAxisOffset.sub(hit.intPt.getIntersectionPoint(), newOrigin);
                Vec3f bar = new Vec3f();
                this.scaleAxisPlane.projectPoint(hit.intPt.getIntersectionPoint(), bar, this.scaleAxisOrigUV);
                this.scaleAxisPlane.setOrigin(hit.intPt.getIntersectionPoint());
                this.origScale.set(this.scale);
            } else {
                this.dragState = 3;
                this.scaleXYZLine.setPoint(hit.intPt.getIntersectionPoint());
                Vec3f scaleDiffVec = new Vec3f();
                scaleDiffVec.sub(hit.intPt.getIntersectionPoint(), this.translation);
                this.scaleXYZLine.setDirection(scaleDiffVec);
                this.origScale.set(this.scale);
                this.origScaleLen = scaleDiffVec.length();
            }
            info.geometry.highlight();
            this.draggedGeometry.add(info.geometry);
            return;
        }
        throw new RuntimeException("Couldn't find intersected piece of geometry");
    }

    public void drag(Vec3f rayStart, Vec3f rayDirection) {
        if (this.dragState == 1) {
            IntersectionPoint intPt = new IntersectionPoint();
            if (!this.dragPlane.intersectRay(rayStart, rayDirection, intPt)) {
                return;
            }
            this.translation.add(intPt.getIntersectionPoint(), this.dragOffset);
            this.recalc();
        } else if (this.dragState == 2) {
            IntersectionPoint intPt = new IntersectionPoint();
            Vec2f uvCoords = new Vec2f();
            if (!this.rotatePlane.intersectRay(rayStart, rayDirection, intPt, uvCoords)) {
                return;
            }
            Rotf offsetRot = new Rotf();
            offsetRot.set(this.rotatePlane.getNormal(), (float)Math.atan2(uvCoords.y(), uvCoords.x()) - this.startAngle);
            this.rotation.mul(offsetRot, this.startRot);
            this.recalc();
        } else if (this.dragState == 3) {
            Vec3f closestPt = new Vec3f();
            boolean gotPt = this.scaleXYZLine.closestPointToRay(rayStart, rayDirection, closestPt);
            if (gotPt) {
                Vec3f newDiffVec = new Vec3f();
                newDiffVec.sub(closestPt, this.translation);
                if (newDiffVec.dot(this.scaleXYZLine.getDirection()) < 0.0f) {
                    this.scale.set(0.0f, 0.0f, 0.0f);
                } else {
                    float scaleChange = newDiffVec.length() / this.origScaleLen;
                    this.scale.set(this.origScale);
                    this.scale.scale(scaleChange);
                }
                this.recalc();
            }
        } else if (this.dragState == 4) {
            IntersectionPoint intPt = new IntersectionPoint();
            Vec2f uvCoords = new Vec2f();
            if (this.scaleAxisPlane.intersectRay(rayStart, rayDirection, intPt, uvCoords)) {
                Vec2f faceCenteredUVCoords = new Vec2f();
                Vec3f foo = new Vec3f();
                Vec3f tmp = new Vec3f();
                tmp.set(intPt.getIntersectionPoint());
                tmp.add(this.scaleAxisOffset);
                this.scaleAxisPlane.projectPoint(tmp, foo, faceCenteredUVCoords);
                if (MathUtil.sgn(faceCenteredUVCoords.x()) == MathUtil.sgn(this.scaleAxisOrigUV.x()) && MathUtil.sgn(faceCenteredUVCoords.y()) == MathUtil.sgn(this.scaleAxisOrigUV.y())) {
                    if (faceCenteredUVCoords.x() < 0.0f) {
                        uvCoords.setX(uvCoords.x() * -1.0f);
                    }
                    if (faceCenteredUVCoords.y() < 0.0f) {
                        uvCoords.setY(uvCoords.y() * -1.0f);
                    }
                    Vec3f scaleVec = new Vec3f();
                    if (Math.abs(uvCoords.x()) > Math.abs(uvCoords.y())) {
                        if (this.scaleAxes == 0) {
                            scaleVec.setX(uvCoords.x());
                        } else if (this.scaleAxes == 1) {
                            scaleVec.setY(uvCoords.x());
                        } else {
                            scaleVec.setZ(uvCoords.x());
                        }
                    } else if (this.scaleAxes == 0) {
                        scaleVec.setY(uvCoords.y());
                    } else if (this.scaleAxes == 1) {
                        scaleVec.setZ(uvCoords.y());
                    } else {
                        scaleVec.setX(uvCoords.y());
                    }
                    scaleVec.setX(scaleVec.x() / this.geometryScale.x());
                    scaleVec.setY(scaleVec.y() / this.geometryScale.y());
                    scaleVec.setZ(scaleVec.z() / this.geometryScale.z());
                    this.scale.add(this.origScale, scaleVec);
                } else if (Math.abs(uvCoords.x()) > Math.abs(uvCoords.y())) {
                    if (this.scaleAxes == 0) {
                        this.scale.setX(0.0f);
                    } else if (this.scaleAxes == 1) {
                        this.scale.setY(0.0f);
                    } else {
                        this.scale.setZ(0.0f);
                    }
                } else if (this.scaleAxes == 0) {
                    this.scale.setY(0.0f);
                } else if (this.scaleAxes == 1) {
                    this.scale.setZ(0.0f);
                } else {
                    this.scale.setX(0.0f);
                }
                this.recalc();
            }
        } else {
            throw new RuntimeException("HandleBoxManip::drag: ERROR: Unexpected drag state");
        }
        super.drag(rayStart, rayDirection);
    }

    public void makeInactive() {
        this.dragState = 0;
        Iterator iter = this.draggedGeometry.iterator();
        while (iter.hasNext()) {
            ((ManipPart)iter.next()).clearHighlight();
        }
        this.draggedGeometry.clear();
    }

    private void createGeometry() {
        ManipPartGroup group = new ManipPartGroup();
        this.lineSegs[0] = this.createLineSeg(new Vec3f(0.0f, 1.0f, 1.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(0.0f, 1.0f, 0.0f));
        this.lineSegs[1] = this.createLineSeg(new Vec3f(-1.0f, 1.0f, 0.0f), new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(0.0f, 1.0f, 0.0f));
        this.lineSegs[2] = this.createLineSeg(new Vec3f(0.0f, 1.0f, -1.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(0.0f, 1.0f, 0.0f));
        this.lineSegs[3] = this.createLineSeg(new Vec3f(1.0f, 1.0f, 0.0f), new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(0.0f, 1.0f, 0.0f));
        this.lineSegs[4] = this.createLineSeg(new Vec3f(-1.0f, 0.0f, 1.0f), new Vec3f(0.0f, -1.0f, 0.0f), new Vec3f(1.0f, 0.0f, 0.0f));
        this.lineSegs[5] = this.createLineSeg(new Vec3f(-1.0f, 0.0f, -1.0f), new Vec3f(0.0f, -1.0f, 0.0f), new Vec3f(1.0f, 0.0f, 0.0f));
        this.lineSegs[6] = this.createLineSeg(new Vec3f(1.0f, 0.0f, -1.0f), new Vec3f(0.0f, -1.0f, 0.0f), new Vec3f(1.0f, 0.0f, 0.0f));
        this.lineSegs[7] = this.createLineSeg(new Vec3f(1.0f, 0.0f, 1.0f), new Vec3f(0.0f, -1.0f, 0.0f), new Vec3f(1.0f, 0.0f, 0.0f));
        this.lineSegs[8] = this.createLineSeg(new Vec3f(0.0f, -1.0f, 1.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(0.0f, 1.0f, 0.0f));
        this.lineSegs[9] = this.createLineSeg(new Vec3f(-1.0f, -1.0f, 0.0f), new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(0.0f, 1.0f, 0.0f));
        this.lineSegs[10] = this.createLineSeg(new Vec3f(0.0f, -1.0f, -1.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(0.0f, 1.0f, 0.0f));
        this.lineSegs[11] = this.createLineSeg(new Vec3f(1.0f, -1.0f, 0.0f), new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(0.0f, 1.0f, 0.0f));
        int i = 0;
        while (i < 12) {
            group.addChild(this.lineSegs[i]);
            ++i;
        }
        FaceInfo info = new FaceInfo();
        info.origNormal.set(0.0f, 0.0f, 1.0f);
        info.centerSquare = this.createFace(info.origNormal, info.origNormal, new Vec3f(0.0f, 1.0f, 0.0f));
        info.lineSegs[0] = this.lineSegs[0];
        info.lineSegs[1] = this.lineSegs[4];
        info.lineSegs[2] = this.lineSegs[7];
        info.lineSegs[3] = this.lineSegs[8];
        info.scaleAxes = 0;
        this.faces.add(info);
        info = new FaceInfo();
        info.origNormal.set(1.0f, 0.0f, 0.0f);
        info.centerSquare = this.createFace(info.origNormal, info.origNormal, new Vec3f(0.0f, 1.0f, 0.0f));
        info.lineSegs[0] = this.lineSegs[3];
        info.lineSegs[1] = this.lineSegs[6];
        info.lineSegs[2] = this.lineSegs[7];
        info.lineSegs[3] = this.lineSegs[11];
        info.scaleAxes = 1;
        this.faces.add(info);
        info = new FaceInfo();
        info.origNormal.set(0.0f, 0.0f, -1.0f);
        info.centerSquare = this.createFace(info.origNormal, info.origNormal, new Vec3f(0.0f, 1.0f, 0.0f));
        info.lineSegs[0] = this.lineSegs[2];
        info.lineSegs[1] = this.lineSegs[5];
        info.lineSegs[2] = this.lineSegs[6];
        info.lineSegs[3] = this.lineSegs[10];
        info.scaleAxes = 0;
        this.faces.add(info);
        info = new FaceInfo();
        info.origNormal.set(-1.0f, 0.0f, 0.0f);
        info.centerSquare = this.createFace(info.origNormal, info.origNormal, new Vec3f(0.0f, 1.0f, 0.0f));
        info.lineSegs[0] = this.lineSegs[1];
        info.lineSegs[1] = this.lineSegs[4];
        info.lineSegs[2] = this.lineSegs[5];
        info.lineSegs[3] = this.lineSegs[9];
        info.scaleAxes = 1;
        this.faces.add(info);
        info = new FaceInfo();
        info.origNormal.set(0.0f, 1.0f, 0.0f);
        info.centerSquare = this.createFace(info.origNormal, info.origNormal, new Vec3f(0.0f, 0.0f, -1.0f));
        info.lineSegs[0] = this.lineSegs[0];
        info.lineSegs[1] = this.lineSegs[1];
        info.lineSegs[2] = this.lineSegs[2];
        info.lineSegs[3] = this.lineSegs[3];
        info.scaleAxes = 2;
        this.faces.add(info);
        info = new FaceInfo();
        info.origNormal.set(0.0f, -1.0f, 0.0f);
        info.centerSquare = this.createFace(info.origNormal, info.origNormal, new Vec3f(0.0f, 0.0f, 1.0f));
        info.lineSegs[0] = this.lineSegs[8];
        info.lineSegs[1] = this.lineSegs[9];
        info.lineSegs[2] = this.lineSegs[10];
        info.lineSegs[3] = this.lineSegs[11];
        info.scaleAxes = 2;
        this.faces.add(info);
        Iterator iter = this.faces.iterator();
        while (iter.hasNext()) {
            group.addChild(((FaceInfo)iter.next()).centerSquare);
        }
        RotateHandleInfo rotInfo = new RotateHandleInfo();
        rotInfo.faceIdx0 = 4;
        rotInfo.faceIdx1 = 1;
        rotInfo.geometry = this.createRotateHandle(new Vec3f(0.0f, 0.0f, 1.0f));
        this.rotateHandles.add(rotInfo);
        rotInfo = new RotateHandleInfo();
        rotInfo.faceIdx0 = 4;
        rotInfo.faceIdx1 = 0;
        rotInfo.geometry = this.createRotateHandle(new Vec3f(1.0f, 0.0f, 0.0f));
        this.rotateHandles.add(rotInfo);
        rotInfo = new RotateHandleInfo();
        rotInfo.faceIdx0 = 4;
        rotInfo.faceIdx1 = 1;
        rotInfo.geometry = this.createRotateHandle(new Vec3f(0.0f, 0.0f, -1.0f));
        this.rotateHandles.add(rotInfo);
        rotInfo = new RotateHandleInfo();
        rotInfo.faceIdx0 = 4;
        rotInfo.faceIdx1 = 0;
        rotInfo.geometry = this.createRotateHandle(new Vec3f(-1.0f, 0.0f, 0.0f));
        this.rotateHandles.add(rotInfo);
        rotInfo = new RotateHandleInfo();
        rotInfo.faceIdx0 = 0;
        rotInfo.faceIdx1 = 1;
        rotInfo.geometry = this.createRotateHandle(new Vec3f(0.0f, 1.0f, 0.0f));
        this.rotateHandles.add(rotInfo);
        rotInfo = new RotateHandleInfo();
        rotInfo.faceIdx0 = 0;
        rotInfo.faceIdx1 = 1;
        rotInfo.geometry = this.createRotateHandle(new Vec3f(0.0f, -1.0f, 0.0f));
        this.rotateHandles.add(rotInfo);
        Iterator iter2 = this.rotateHandles.iterator();
        while (iter2.hasNext()) {
            group.addChild(((RotateHandleInfo)iter2.next()).geometry);
        }
        ScaleHandleInfo scaleInfo = new ScaleHandleInfo();
        scaleInfo.geometry = this.createScaleHandle(new Vec3f(1.0f, 1.0f, 1.0f));
        scaleInfo.faceIndices[0] = 0;
        scaleInfo.faceIndices[1] = 1;
        scaleInfo.faceIndices[2] = 4;
        this.scaleHandles.add(scaleInfo);
        scaleInfo = new ScaleHandleInfo();
        scaleInfo.geometry = this.createScaleHandle(new Vec3f(1.0f, 1.0f, -1.0f));
        scaleInfo.faceIndices[0] = 1;
        scaleInfo.faceIndices[1] = 2;
        scaleInfo.faceIndices[2] = 4;
        this.scaleHandles.add(scaleInfo);
        scaleInfo = new ScaleHandleInfo();
        scaleInfo.geometry = this.createScaleHandle(new Vec3f(1.0f, -1.0f, 1.0f));
        scaleInfo.faceIndices[0] = 0;
        scaleInfo.faceIndices[1] = 1;
        scaleInfo.faceIndices[2] = 5;
        this.scaleHandles.add(scaleInfo);
        scaleInfo = new ScaleHandleInfo();
        scaleInfo.geometry = this.createScaleHandle(new Vec3f(1.0f, -1.0f, -1.0f));
        scaleInfo.faceIndices[0] = 1;
        scaleInfo.faceIndices[1] = 2;
        scaleInfo.faceIndices[2] = 5;
        this.scaleHandles.add(scaleInfo);
        scaleInfo = new ScaleHandleInfo();
        scaleInfo.geometry = this.createScaleHandle(new Vec3f(-1.0f, 1.0f, 1.0f));
        scaleInfo.faceIndices[0] = 0;
        scaleInfo.faceIndices[1] = 3;
        scaleInfo.faceIndices[2] = 4;
        this.scaleHandles.add(scaleInfo);
        scaleInfo = new ScaleHandleInfo();
        scaleInfo.geometry = this.createScaleHandle(new Vec3f(-1.0f, 1.0f, -1.0f));
        scaleInfo.faceIndices[0] = 2;
        scaleInfo.faceIndices[1] = 3;
        scaleInfo.faceIndices[2] = 4;
        this.scaleHandles.add(scaleInfo);
        scaleInfo = new ScaleHandleInfo();
        scaleInfo.geometry = this.createScaleHandle(new Vec3f(-1.0f, -1.0f, 1.0f));
        scaleInfo.faceIndices[0] = 0;
        scaleInfo.faceIndices[1] = 3;
        scaleInfo.faceIndices[2] = 5;
        this.scaleHandles.add(scaleInfo);
        scaleInfo = new ScaleHandleInfo();
        scaleInfo.geometry = this.createScaleHandle(new Vec3f(-1.0f, -1.0f, -1.0f));
        scaleInfo.faceIndices[0] = 2;
        scaleInfo.faceIndices[1] = 3;
        scaleInfo.faceIndices[2] = 5;
        this.scaleHandles.add(scaleInfo);
        Iterator iter3 = this.scaleHandles.iterator();
        while (iter3.hasNext()) {
            group.addChild(((ScaleHandleInfo)iter3.next()).geometry);
        }
        this.parts = group;
    }

    private ManipPart createLineSeg(Vec3f translation, Vec3f xAxis, Vec3f yAxis) {
        ManipPartTransform xform = new ManipPartTransform();
        ManipPartLineSeg lineSeg = new ManipPartLineSeg();
        xform.addChild(lineSeg);
        Mat4f offset = new Mat4f();
        offset.makeIdent();
        Vec3f zAxis = new Vec3f();
        zAxis.cross(xAxis, yAxis);
        offset.set(0, 0, xAxis.x());
        offset.set(1, 0, xAxis.y());
        offset.set(2, 0, xAxis.z());
        offset.set(0, 1, yAxis.x());
        offset.set(1, 1, yAxis.y());
        offset.set(2, 1, yAxis.z());
        offset.set(0, 2, zAxis.x());
        offset.set(1, 2, zAxis.y());
        offset.set(2, 2, zAxis.z());
        offset.set(0, 3, translation.x());
        offset.set(1, 3, translation.y());
        offset.set(2, 3, translation.z());
        xform.setOffsetTransform(offset);
        return xform;
    }

    private ManipPart createFace(Vec3f translation, Vec3f normal, Vec3f up) {
        ManipPartTransform xform = new ManipPartTransform();
        ManipPartSquare square = new ManipPartSquare();
        square.setVisible(false);
        xform.addChild(square);
        Mat4f offset = new Mat4f();
        offset.makeIdent();
        Vec3f right = new Vec3f();
        right.cross(up, normal);
        offset.set(0, 0, right.x());
        offset.set(1, 0, right.y());
        offset.set(2, 0, right.z());
        offset.set(0, 1, up.x());
        offset.set(1, 1, up.y());
        offset.set(2, 1, up.z());
        offset.set(0, 2, normal.x());
        offset.set(1, 2, normal.y());
        offset.set(2, 2, normal.z());
        offset.set(0, 3, translation.x());
        offset.set(1, 3, translation.y());
        offset.set(2, 3, translation.z());
        xform.setOffsetTransform(offset);
        return xform;
    }

    private ManipPart createRotateHandle(Vec3f direction) {
        ManipPartCube handle = new ManipPartCube();
        Mat4f offset = new Mat4f();
        offset.makeIdent();
        offset.set(0, 0, 0.1f);
        offset.set(1, 1, 0.1f);
        offset.set(2, 2, 0.1f);
        Vec3f scaledDirection = new Vec3f(direction);
        scaledDirection.scale(2.0f);
        offset.setTranslation(scaledDirection);
        ManipPartTransform xform = new ManipPartTransform();
        xform.addChild(handle);
        xform.setOffsetTransform(offset);
        return xform;
    }

    private ManipPart createScaleHandle(Vec3f position) {
        ManipPartCube handle = new ManipPartCube();
        Mat4f offset = new Mat4f();
        offset.makeIdent();
        offset.set(0, 0, 0.1f);
        offset.set(1, 1, 0.1f);
        offset.set(2, 2, 0.1f);
        offset.setTranslation(position);
        ManipPartTransform xform = new ManipPartTransform();
        xform.addChild(handle);
        xform.setOffsetTransform(offset);
        return xform;
    }

    private void recalc() {
        Mat4f scaleMat = new Mat4f();
        Mat4f rotMat = new Mat4f();
        Mat4f xlateMat = new Mat4f();
        Mat4f tmpMat = new Mat4f();
        scaleMat.makeIdent();
        scaleMat.set(0, 0, this.scale.x() * this.geometryScale.x());
        scaleMat.set(1, 1, this.scale.y() * this.geometryScale.y());
        scaleMat.set(2, 2, this.scale.z() * this.geometryScale.z());
        rotMat.makeIdent();
        rotMat.setRotation(this.rotation);
        xlateMat.makeIdent();
        xlateMat.set(0, 3, this.translation.x());
        xlateMat.set(1, 3, this.translation.y());
        xlateMat.set(2, 3, this.translation.z());
        tmpMat.mul(xlateMat, rotMat);
        this.xform.mul(tmpMat, scaleMat);
        int i = 0;
        while (i < 12) {
            this.lineSegs[i].setTransform(this.xform);
            ++i;
        }
        i = 0;
        while (i < this.faces.size()) {
            FaceInfo face = (FaceInfo)this.faces.get(i);
            face.centerSquare.setTransform(this.xform);
            this.xform.xformDir(face.origNormal, face.normal);
            face.normal.normalize();
            RotateHandleInfo rotInfo = (RotateHandleInfo)this.rotateHandles.get(i);
            rotInfo.geometry.setTransform(this.xform);
            ++i;
        }
        i = 0;
        while (i < this.scaleHandles.size()) {
            ((ScaleHandleInfo)this.scaleHandles.get((int)i)).geometry.setTransform(this.xform);
            ++i;
        }
    }

    static {
        INACTIVE = 0;
        TRANSLATE = 1;
        ROTATE = 2;
        SCALE_XYZ = 3;
        SCALE_SINGLE_AXIS = 4;
        SCALE_XY = 0;
        SCALE_YZ = 1;
        SCALE_ZX = 2;
    }

    static class ScaleHandleInfo {
        ManipPart geometry;
        int[] faceIndices = new int[3];

        ScaleHandleInfo() {
        }
    }

    static class RotateHandleInfo {
        ManipPart geometry;
        int faceIdx0;
        int faceIdx1;

        RotateHandleInfo() {
        }
    }

    static class FaceInfo {
        ManipPart[] lineSegs = new ManipPart[4];
        ManipPart centerSquare;
        Vec3f origNormal = new Vec3f();
        Vec3f normal = new Vec3f();
        int scaleAxes;

        FaceInfo() {
        }
    }
}

