/* Test program, used by the format-c-4 test.
   Copyright (C) 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <locale.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_INTTYPES_H
# include <inttypes.h>
#endif
#include "xsetenv.h"

/* Make sure we use the included libintl, not the system's one. */
#undef _LIBINTL_H
#include "libgnuintl.h"

#define _(string) gettext (string)

/* Fallback definition.  */
#ifndef PRId8
# define PRId8 "d"
#endif

int main (argc, argv)
  int argc;
  char *argv[];
{
/* This test requires ANSI C string concatenation.  */
#ifdef __STDC__
  unsigned char n = 5;
  const char *s;
  const char *c1;
  const char *c2;
  char buf[100];

  xsetenv ("LC_ALL", argv[1], 1);
  if (setlocale (LC_ALL, "") == NULL)
    {
      fprintf (stderr, "Couldn't set locale.\n");
      exit (1);
    }

  textdomain ("fc4");
  bindtextdomain ("fc4", ".");

  s = ngettext ("father of %"PRId8" child", "father of %"PRId8" children", n);
  c1 = "Vater von %"; c2 = " Kindern";

  if (!(strlen (s) > strlen (c1) + strlen (c2)
	&& memcmp (s, c1, strlen (c1)) == 0
	&& memcmp (s + strlen (s) - strlen (c2), c2, strlen (c2)) == 0))
    {
      fprintf (stderr, "String not translated.\n");
      exit (1);
    }
  if (strchr (s, '<') != NULL || strchr (s, '>') != NULL)
    {
      fprintf (stderr, "Translation contains <...> markers.\n");
      exit (1);
    }
  sprintf (buf, s, n);
  if (strcmp (buf, "Vater von 5 Kindern") != 0)
    {
      fprintf (stderr, "printf of translation wrong.\n");
      exit (1);
    }
  return 0;
#else
  exit (77);
#endif
}
