;;; erc-compat.el --- ERC compatibility code for XEmacs

;; Copyright (C) 2002  Alex Schroeder

;; Author: Alex Schroeder <alex@gnu.org>
;; URL: http://www.emacswiki.org/cgi-bin/wiki.pl?EmacsIRCClient

;; This file is not part of GNU Emacs.

;; This is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; This mostly defines stuff that cannot be worked around easily.

;;; Code:

;; erc-define-minor-mode: the easy-mmode-define-minor-mode available
;; in XEmacs' easy-mmode.el does not have the BODY argument.  This
;; code has to work, even if somebody has defaliased
;; easy-mmode-define-minor-mode to define-minor-mode.  The code runs a
;; test first, and if define-minor-mode works, it uninterns all the
;; symbols created, so nothing should be left behind.

;;;###autoload (autoload 'erc-define-minor-mode "erc-compat")
(condition-case nil
    (progn
      (define-minor-mode erc-compat-test "Testing `define-minor-mode'." nil nil nil (ignore))
      (mapc 'unintern (apropos-internal "^erc-compat-test"))
      (defalias 'erc-define-minor-mode 'define-minor-mode))
  (error 
   (defmacro erc-define-minor-mode (mode doc &optional init-value lighter keymap &rest body)
     "Define a minor mode like in Emacs."
     `(progn
	(defvar ,mode ,init-value "Non-nil if the corresponding mode is enabled.")
	(defun ,mode (&optional arg)
	  ,doc
	  (interactive)
	  (setq ,mode (if arg
			  (> (prefix-numeric-value arg) 0)
			(not ,mode)))
	  ,@body
	  ,mode)
	(add-minor-mode ,mode ,lighter ,keymap)))))

;; MULE: decode-coding-string and encode-coding-string -- note that
;; XEmacs' functions do not have the NOCOPY argument.

(condition-case nil
    ;; Try 3 arguments
    (progn
      (decode-coding-string "a" 'latin-1 t)
      (defun erc-decode-coding-string (s)
	"Decode characters.  The correct coding system is guessed by Emacs."
	(decode-coding-string s 'undecided t)))
  (error
   (condition-case nil
       ;; Try 2 arguments
       (progn
	 (decode-coding-string "a" 'latin-1)
	 (defun erc-decode-coding-string (s)
	   "Decode characters.  The correct coding system is guessed by Emacs."
	   (decode-coding-string s 'undecided)))
     (error
      ;; Default
      (defalias 'erc-decode-coding-string 'identity)))))

(condition-case nil
    ;; Try 3 arguments
    (progn
      (encode-coding-string "a" 'latin-1 t)
      (defun erc-encode-coding-string (s)
	"Encode characters as `ctext'."
	(encode-coding-string s 'ctext t)))
  (error
   (condition-case nil
       ;; Try 2 arguments
       (progn
	 (encode-coding-string "a" 'latin-1)
	 (defun erc-encode-coding-string (s)
	   "Encode characters as `ctext'."
	   (encode-coding-string s 'ctext)))
     (error
      ;; Default
      (defalias 'erc-encode-coding-string 'identity)))))

(provide 'erc-compat)

;;; erc-compat.el ends here
