/*
 * grp.h - Group file emulation.
 *
 * This file is part of the Portable.NET C library.
 * Copyright (C) 2004  Southern Storm Software, Pty Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _GRP_H
#define _GRP_H

#include <features.h>
#include <sys/types.h>

__BEGIN_DECLS

/* Group file entry information block */
struct group
  {
    char  *gr_name;
    gid_t  gr_gid;
    char **gr_mem;
  };

/* Function prototypes */
extern void setgrent(void);
extern struct group *getgrent(void);
extern void endgrent(void);
extern struct group *getgrnam(const char *__name);
extern struct group *getgrgid(gid_t __gid);
extern int getgrnam_r(const char *__name,
                      struct group * __restrict __resultbuf,
                      char * __restrict __buffer, size_t __buflen,
                      struct group ** __restrict __result);
extern int getgrgid_r(gid_t __gid,
                      struct group * __restrict __resultbuf,
                      char * __restrict __buffer, size_t __buflen,
                      struct group ** __restrict __result);

__END_DECLS

#endif  /* !_GRP_H */
