 // 
// System.Web.Services.Configuration.XmlFormatExtensionAttribute.cs
//
// Author:
//   Tim Coleman (tim@timcoleman.com)
//
// Copyright (C) Tim Coleman, 2002
//

namespace System.Web.Services.Configuration {
	[AttributeUsage (AttributeTargets.Class, Inherited = true)]
	public sealed class XmlFormatExtensionAttribute : Attribute {

		#region Fields

		string elementName;
		string ns;
		Type[] extensionPoints;

		#endregion // Fields

		#region Constructors

		public XmlFormatExtensionAttribute ()
		{
		}

		public XmlFormatExtensionAttribute (string elementName, string ns, Type extensionPoint1)
			: this (elementName, ns, new Type[1] {extensionPoint1})
		{
		}

		public XmlFormatExtensionAttribute (string elementName, string ns, Type[] extensionPoints)
			: this ()
		{
			this.elementName = elementName;
			this.ns = ns;
			this.extensionPoints = extensionPoints;
		}

		public XmlFormatExtensionAttribute (string elementName, string ns, Type extensionPoint1, Type extensionPoint2)
			: this (elementName, ns, new Type[2] {extensionPoint1, extensionPoint2})
		{
		}

		public XmlFormatExtensionAttribute (string elementName, string ns, Type extensionPoint1, Type extensionPoint2, Type extensionPoint3)
			: this (elementName, ns, new Type[3] {extensionPoint1, extensionPoint2, extensionPoint3})
		{
		}

		public XmlFormatExtensionAttribute (string elementName, string ns, Type extensionPoint1, Type extensionPoint2, Type extensionPoint3, Type extensionPoint4)
			: this (elementName, ns, new Type[4] {extensionPoint1, extensionPoint2, extensionPoint3, extensionPoint4})
		{
		}
		
		#endregion // Constructors

		#region Properties

		public string ElementName {
			get { return elementName; }
			set { elementName = value; }
		}

		public Type[] ExtensionPoints {
			get { return extensionPoints; }
			set { extensionPoints = value; }
		}

		public string Namespace {
			get { return ns; }
			set { ns = value; }
		}

		#endregion // Properties
	}
}
