# rpms.mak - Makefile targets to generate rpms automatically
# Copyright (C) 1999 suzuki toshiya
#
# Author: suzuki toshiya <suzukis@file.phys.tohoku.ac.jp>
#
# This is part of gtkDPS now. However these targets might be useful
# for other program.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# As a special exception to the GNU General Public License, if you
# distribute this file as part of a program that contains a
# configuration script generated by Autoconf, you may include it under
# the same distribution terms that you use for the rest of that program.
#
RPM =	@RPM@
RPM_VER_MAJOR =	@rpm_ver_major@
RPM_VER_MINOR =	@rpm_ver_minor@
RPM_VER_REL =	@rpm_ver_rel@
RPMFLAGS =	@RPMFLAGS@

${PACKAGE}-${VERSION}.tar.gz:
	make dist

rpmdirs:
	mkdir -p SRPMS BUILD SPECS ;\
	RPM_ARCHS=`${RPM} --showrc | sed -n 's#^compatible archs *: ##p'` ;\
	for RPM_ARCH in $${RPM_ARCHS} ; do\
	  mkdir -p RPMS/$${RPM_ARCH} ;\
	done
 
srpm: rpmdirs ${PACKAGE}-${VERSION}.tar.gz ${PACKAGE}.spec
	${RPM} -bs -vv ${RPMFLAGS} ${PACKAGE}.spec
 
rpm: srpm
	${RPM} --rebuild -vv ${RPMFLAGS} \
	SRPMS/${PACKAGE}-${VERSION}-${run_config_date}.*src.rpm
