#! /usr/bin/env perl
#
#       Create a Perl module that initializes and exports a varaible.
#	Create a Construct file that uses the module, and two
#	Conscript files, one that uses the module and one that
#	doesn't.  Print the contents of the module variable (and
#	an exported variable, for a sanity check) in all three
#	files.  Check that we only see the module variable's
#	initialized value in the Construct/Conscript files that
#	use the module.
#

#
#       10 Aug 2000 Johan Holmberg  <holmberg@iar.se>
#

# $Id: t0083.t,v 1.1 2000/10/29 15:57:24 knight Exp $

# Copyright (c) 1996-2000 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

use Test::Cmd::Cons;

$test = Test::Cmd::Cons->new(string => 'script:: variables');

#
$test->write("Components", <<'_EOF_');
package Components;

$gcc = "/usr/home/$script::foo/bin/gcc";

1;

_EOF_

$test->write("Construct", <<'_EOF_');
$foo = 'me';

require 'Components';

print "gcc = $Components::gcc\n";
_EOF_

#
$test->run('chdir' => '.', stdout => <<'_EOF_');
gcc = /usr/home/me/bin/gcc
_EOF_

#
$test->pass;
__END__
