#! /usr/bin/env perl
#
#	Create three files from Command invocations, the first two
#	from Construct and the third from a subsidiary Conscript.
#	Construct and Conscript files both define a same-named subroutine.
#	The first file is created by in-line Perl code prepended with
#	"[perl]".  The second is created by in-line Perl code that calls
#	the subroutine; it should find the one in the Construct file.
#	The third is created by a multi-line Command where the first
#	and last lines are external commands and the middle two are
#	in-line Perl.  The third line "echos" two lines to a file (using
#	an external Perl call), uses Perl to print another line, and also
#	calls the subroutine, on separate lines; it should handle the
#	multi-line commands correctly and find the subroutine in the
#	Conscript file.  Rewrite the Construct file to change the Perl
#	code that creates the file.  Re-run Cons and check that the file
#	was changed.
#

# $Id: t0081.t,v 1.3 2000/10/17 17:49:38 knight Exp $

# Copyright (c) 1996-2000 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

use Test::Cmd::Cons qw($_exe);

$test = Test::Cmd::Cons->new(string => '[perl] build actions');

#
$test->write("Construct", <<_EOF_);
\$env = new cons ( ${\$test->cons_env} );
sub printsub {
	my \$file = shift;
	open(F, ">\$file");
	print F "Construct printsub\n";
	close(F);
	return 1;
}
Command \$env 'foo',
    qq([perl] open(F, ">%>"); print F "xyzzy\\\\n"; close(F); 1);
Command \$env 'bar', qq([perl] &printsub('%>'));
Export qw( env );
Build 'Conscript';
_EOF_

$test->write("Conscript", <<_EOF_);
Import qw( env );
sub printsub {
	my \$file = shift;
	open(F, ">>\$file");
	print F "Conscript printsub\n";
	close(F);
	return 1;
}
Command \$env 'baz', qq(
	\Q$^X\E -e "print 'line 1', \\\\"\\\\n\\\\"" >> %>
	[perl] open(F, ">>%>"); print F "line 2\\\\n"; close(F); 1
	[perl] &printsub('%>'); 1
	\Q$^X\E -e "print 'line 3', \\\\"\\\\n\\\\"" >> %>
);
_EOF_

#
$test->run(targets => ".");

$test->file_matches('foo', <<_EOF_);
xyzzy
_EOF_

$test->file_matches('bar', <<_EOF_);
Construct printsub
_EOF_

$test->file_matches('baz', <<_EOF_);
line 1
line 2
Conscript printsub
line 3
_EOF_

#
$test->up_to_date(targets => ".");

#
$test->write("Construct", <<_EOF_);
\$env = new cons ( ${\$test->cons_env} );
sub printsub {
	my \$file = shift;
	open(F, ">\$file");
	print F "Construct printsub again\n";
	close(F);
	return 1;
}
\$variable = '12345';
Command \$env 'foo',
    qq([perl] open(F, ">%>"); print F "\$variable \\\$variable\\\\n"; close(F); 1);
Command \$env 'bar', qq([perl] &printsub('%>'));
Export qw( env );
Build 'Conscript';
_EOF_

#
$test->run(targets => ".");

$test->file_matches('foo', <<_EOF_);
12345 12345
_EOF_

$test->file_matches('bar', <<_EOF_);
Construct printsub
_EOF_

#
$test->pass;
__END__
