#! /usr/bin/env perl
#
#	Set up a Construct and Conscript file to build a Program.
#	Make sure it builds correctly.	Build an object file with a
#	normal path name, and with the directory separators doubled.
#	Specify the subdirectory and build the program.  Add a separator
#	to the end of the argument and build again.  Add a separator to
#	the end of the file name argument and build again.
#

# $Id: t0080.t,v 1.2 2000/09/20 13:50:32 rv Exp $

# Copyright (c) 1996-2000 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

use Test::Cmd::Cons qw($_exe $_o);

$test = Test::Cmd::Cons->new(string => 'directory separators');

$test->subdir('sub', ['sub', 'dir']);

#
$sub_dir_Conscript = $test->catfile('sub', 'dir', 'Conscript');
$sub_dir_foo = $test->catfile('sub', 'dir', 'foo');
$sub_dir_foo_exe = $test->catfile('sub', 'dir', "foo$_exe");
$sub_dir_aaa_o = $test->catfile('sub', 'dir', "aaa$_o");
$sub_dir_bbb_o = $test->catfile('sub', 'dir', "bbb$_o");

($sub__dir__aaa_o = $sub_dir_aaa_o) =~ s/sub(.+)dir(.+)aaa/sub$1$1dir$2$2aaa/;

$sd = $test->catdir('sub', 'dir');
if ($sd =~ /dir$/) {
	$sub_dir = $sd;
	($sub_dir_ = $sd) =~ s/sub(.+)dir/sub$1dir$1/;
} else {
	$sub_dir_ = $sd;
	($sub_dir = $sd) =~ s/dir.+$/dir/;
}

($sub_dir_foo_exe_ = $sub_dir_foo_exe) =~ s/dir(.+)foo(.*)/dir$1foo$2$1/;

#
$test->write("Construct", <<_EOF_);
Build qw(
	$sub_dir_Conscript
);
_EOF_

$test->write($sub_dir_Conscript, <<_EOF_);
\$env = new cons ( ${\$test->cons_env} );
Program \$env 'foo', qw (
	aaa.c
	bbb.c
	main.c
);
_EOF_

$test->write(['sub', 'dir', 'aaa.c'], <<'_EOF_');
void
aaa(void)
{
	printf("aaa.c\n");
}
_EOF_

$test->write(['sub', 'dir', 'bbb.c'], <<'_EOF_');
void
bbb(void)
{
	printf("bbb.c\n");
}
_EOF_

$test->write(['sub', 'dir', 'main.c'], <<'_EOF_');
extern void aaa(void);
extern void bbb(void);
int
main(int argc, char *argv[])
{
	aaa();
	bbb();
	printf("main.c\n");
	exit (0);
}
_EOF_

#
$test->run(targets => ".");

$test->execute(prog => $sub_dir_foo, stdout => <<_EOF_);
aaa.c
bbb.c
main.c
_EOF_

#
$test->run(flags => "-r", targets => ".");
$test->must_not_exist($sub_dir_aaa_o);
$test->must_not_exist($sub_dir_bbb_o);

#
$test->run(targets => $sub_dir_aaa_o);
$test->must_exist($sub_dir_aaa_o);

#
$test->run(flags => "-r", targets => ".");
$test->must_not_exist($sub_dir_aaa_o);
$test->must_not_exist($sub_dir_bbb_o);

#
$test->run(targets => $sub__dir__aaa_o);
$test->must_exist($sub_dir_aaa_o);

#
$test->run(flags => "-r", targets => ".");
$test->must_not_exist($sub_dir_foo_exe);

#
$test->run(targets => $sub_dir);
$test->must_exist($sub_dir_foo_exe);

#
$test->run(flags => "-r", targets => ".");
$test->must_not_exist($sub_dir_foo_exe);

#
$test->run(targets => $sub_dir_);
$test->must_exist($sub_dir_foo_exe);

#
$test->run(flags => "-r", targets => ".");
$test->must_not_exist($sub_dir_foo_exe);

#
$test->run(targets => $sub_dir_foo_exe_);
$test->must_exist($sub_dir_foo_exe);

#
$test->pass;
__END__
