#! /usr/bin/env perl
#
#	Build a Program from two .c files in the current directory, and
#	another from two .c files in a subdirectory.  Use Perl filename
#	globbing to select the .c files.  Run Cons; make sure both
#	built correctly.  Add another .c file to the current directory
#	and the subdirectory (and rewrite one existing .c file in each
#	to call its new subroutine).  Run Cons; see the the globbing
#	correctly re-built each program with all three .c files.
#

# $Id: t0076.t,v 1.4 2000/09/10 05:01:27 knight Exp $

# Copyright (c) 1996-2000 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

use Test::Cmd::Cons;

$test = Test::Cmd::Cons->new(string => 'filename globbing');

$test->subdir('subdir');

$subdir_Conscript = $test->catfile('subdir', 'Conscript');
$subdir_bar = $test->catfile('subdir', 'bar');

#
$test->write("Construct", <<_EOF_);
Conscript_chdir 1;
\$env = new cons ( ${\$test->cons_env} );
Export qw( env );
Program \$env 'foo', <*.c>;
Build '$subdir_Conscript';
_EOF_

$test->write("aaa.c", <<'_EOF_');
void
aaa(void)
{
	printf("aaa.c\n");
}
_EOF_

$test->write("main.c", <<'_EOF_');
extern void aaa(void);
int
main(int argc, char *argv[])
{
	aaa();
	printf("main.c\n");
	exit (0);
}
_EOF_

$test->write($subdir_Conscript, <<_EOF_);
Import qw( env );
Program \$env 'bar', <*.c>;
_EOF_

$test->write(['subdir', 'xxx.c'], <<'_EOF_');
void
xxx(void)
{
	printf("subdir/xxx.c\n");
}
_EOF_

$test->write(['subdir', 'main.c'], <<'_EOF_');
extern void xxx(void);
int
main(int argc, char *argv[])
{
	xxx();
	printf("subdir/main.c\n");
	exit (0);
}
_EOF_

#
$test->run(targets => ".");

$test->execute(prog => 'foo', stdout => <<_EOF_);
aaa.c
main.c
_EOF_

$test->execute(prog => $subdir_bar, stdout => <<_EOF_);
subdir/xxx.c
subdir/main.c
_EOF_

#
$test->write("bbb.c", <<'_EOF_');
void
bbb(void)
{
	printf("bbb.c\n");
}
_EOF_

$test->write("main.c", <<'_EOF_');
extern void aaa(void);
extern void bbb(void);
int
main(int argc, char *argv[])
{
	aaa();
	bbb();
	printf("main.c\n");
	exit (0);
}
_EOF_

$test->write(['subdir', 'yyy.c'], <<'_EOF_');
void
yyy(void)
{
	printf("subdir/yyy.c\n");
}
_EOF_

$test->write(['subdir', 'main.c'], <<'_EOF_');
extern void xxx(void);
extern void yyy(void);
int
main(int argc, char *argv[])
{
	xxx();
	yyy();
	printf("subdir/main.c\n");
	exit (0);
}
_EOF_

#
$test->run(targets => ".");

$test->execute(prog => 'foo', stdout => <<_EOF_);
aaa.c
bbb.c
main.c
_EOF_

$test->execute(prog => $subdir_bar, stdout => <<_EOF_);
subdir/xxx.c
subdir/yyy.c
subdir/main.c
_EOF_

$test->pass;
__END__
