#! /usr/bin/env perl
#
#	Define an environment with some construction variables.
#	Print a bunch of variable expansions to a file in all
#	sorts of combinations, interspersed with different
#	numbers of % signs.  Check that the output matches
#	what we expect.
#

# $Id: t0075.t,v 1.1 2000/07/26 12:23:45 knight Exp $

# Copyright (c) 1996-2000 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

use Test::Cmd::Cons;

$test = Test::Cmd::Cons->new(string => '% expansion');

#
$test->write('Construct', <<_EOF_);
\%env_hash = ( ${\$test->cons_env} );
\$env_hash{FOO} = 'foo';
\$env_hash{BAR} = 'bar';
\$env_hash{FOOBAR} = '_foobar_';
\$env_hash{fooBAR} = 'BUG!';
\$env_hash{FOObar} = 'BUG!  You should see foobar, not this.';
\$env = new cons ( \%env_hash );
Command \$env 'output', 'foo.in', qq(
	\Q$^X\E -e "print '% %FOO % %BAR %', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%% %{FOO %% %BAR} %%', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%%% %{FOO} %%% %{BAR} %%%', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print 'FOOBAR', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print 'FOO%BAR', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print 'FOO%%BAR', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print 'FOO%%%BAR', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print 'FOO%%%%BAR', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%FOOBAR', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%FOO%BAR', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%FOO%%BAR', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%FOO%%%BAR', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%FOO%%%%BAR', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%{FOO}BAR', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%{FOO}%BAR', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%{FOO}%%BAR', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%{FOO}%%%BAR', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%{FOO}%%%%BAR', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%{FOO}{BAR}', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%{FOO}%{BAR}', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%{FOO}%%{BAR}', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%{FOO}%%%{BAR}', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%{FOO}%%%%{BAR}', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%FOO{BAR}', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%FOO%{BAR}', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%FOO%%{BAR}', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%FOO%%%{BAR}', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print '%FOO%%%%{BAR}', \\\\"\\\\n\\\\"" >> %>
);
_EOF_

$test->write('foo.in', <<_EOF_);
foo.in
_EOF_

#
$test->run(targets => ".");

$test->file_matches('output', <<_EOF_);
% foo % bar %
% %{FOO % bar} %
%% foo %% bar %%
FOOBAR
FOObar
FOO%BAR
FOO%bar
FOO%%BAR
_foobar_
foobar
foo%BAR
foo%bar
foo%%BAR
fooBAR
foobar
foo%BAR
foo%bar
foo%%BAR
foo{BAR}
foobar
foo%{BAR}
foo%bar
foo%%{BAR}
foo{BAR}
foobar
foo%{BAR}
foo%bar
foo%%{BAR}
_EOF_

#
$test->pass;
__END__
