#! /usr/bin/env perl
#
#	Create a Construct file and a Conscript file in a source
#	subdirectory.  The Construct file prints to an output file the
#	result of two SourcePath calls, one each to an existent and
#	non-existent file.  The Conscript prints to an output file the
#	result of a single SourcePath call with two arguments, one each
#	to an existent and non-existent file, but returned to an array.
#	The source subdirectory is Linked to a build subdirectory.
#	Check the output files.
#

# $Id: t0052.t,v 1.4 2000/11/16 12:22:38 knight Exp $

# Copyright (c) 1996-2000 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

use Test::Cmd::Cons;
use Config;

$test = Test::Cmd::Cons->new(string => 'SourcePath');

$test->subdir('src');

#
$build_Conscript = $test->catfile('build', 'Conscript');
$build_bbb_out = $test->catfile('build', 'bbb.out');
$build_bbb_pl = $test->catfile('build', 'bbb.pl');
$src_Conscript = $test->catfile('src', 'Conscript');
$src_bbb_pl = $test->catfile('src', 'bbb.pl');
$src_exists = $test->catfile('src', 'exists');
$src_does_not_exist = $test->catfile('src', 'does_not_exist');

#
$test->write('Construct', <<_EOF_);
\$env = new cons ( ${\$test->cons_env} );
Export qw( env );
Link 'build' => 'src';
Build '$build_Conscript';
\$sp_exists = SourcePath 'exists';
\$sp_does_not_exist = SourcePath 'does_not_exist';
Command \$env 'aaa.out', 'aaa.pl', qq(
	\Q$^X\E %< > %>
	\Q$^X\E -e "print 'sp_exists = \$sp_exists', \\\\"\\\\n\\\\"" >> %>
	\Q$^X\E -e "print 'sp_does_not_exist = \$sp_does_not_exist', \\\\"\\\\n\\\\"" >> %>
);
_EOF_

$test->write($src_Conscript, <<_EOF_);
Import qw( env );
\@sp_arr = SourcePath 'exists', 'does_not_exist';
Command \$env 'bbb.out', 'bbb.pl', qq(
	\Q$^X\E %< > %>
	\Q$^X\E -e "print 'sp_arr = \@sp_arr', \\\\"\\\\n\\\\"" >> %>
);
_EOF_

$test->write('aaa.pl', <<_EOF_);
$Config{startperl}
print "aaa.pl:  \$0\\n";
exit(0);
_EOF_

$test->write('exists', <<_EOF_);
exists
_EOF_

$test->write(['src', 'bbb.pl'], <<_EOF_);
$Config{startperl}
print "src/bbb.pl:  \$0\\n";
exit(0);
_EOF_

$test->write('exists', <<_EOF_);
src/exists
_EOF_

#
$test->run(targets => ".");

$test->file_matches('aaa.out', <<_EOF_);
aaa.pl:  aaa.pl
sp_exists = exists
sp_does_not_exist = does_not_exist
_EOF_

$test->file_matches($build_bbb_out, <<_EOF_);
$src_bbb_pl:  $build_bbb_pl
sp_arr = $src_exists $src_does_not_exist
_EOF_

#
$test->pass;
__END__
