/* cfengine for GNU
 
        Copyright (C) 1995
        Free Software Foundation, Inc.
 
   This file is part of GNU cfengine - written and maintained 
   by Mark Burgess, Dept of Computing and Engineering, Oslo College,
   Dept. of Theoretical physics, University of Oslo
 
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA

*/
/*****************************************************************************/
/*                                                                           */
/* File: log.c                                                               */
/*                                                                           */
/*****************************************************************************/

#include "cf.defs.h"
#include "cf.extern.h"

/*****************************************************************************/

CfLog(level,string,errstr)

enum cfoutputlevel level;
char *string, *errstr;

{ char endl;

 switch(level)
   {
   case cfsilent:    if (! SILENT || VERBOSE || DEBUG || D2)
                        {
			printf("%s: %s",VPREFIX,string);
                        }
                     break;
		     
   case cfinform:    if (SILENT)
                        {
			return;
                        }
   
                     if (INFORM || VERBOSE || DEBUG || D2)
                        {
			printf("%s: %s",VPREFIX,string);
                        }
		     
		     if (LOGGING && (getuid() == 0))
			{
			syslog(LOG_ERR,string,VFQNAME);
			syslog(LOG_ERR,errstr,VFQNAME);
			syslog(LOG_ERR,strerror(errno),VFQNAME);			
			}
                     break;
			
   case cfverbose:   if (VERBOSE || DEBUG || D2)
                        {
			if ((errstr == NULL) || (strlen(errstr) > 0))
			   {
			   printf("%s: %s",VPREFIX,string);
			   printf("%s: %s",VPREFIX,errstr);
			   }
			else
			   {
			   printf("%s: %s",VPREFIX,string);
			   }
                        }
                     break;

   case cfeditverbose: if (EDITVERBOSE || DEBUG)
                        {
			printf("%s: %s",VPREFIX,string);
                        }
                     break;

   case cflogonly:
                     if (LOGGING && getuid() == 0)
			{
			syslog(LOG_INFO,string,VFQNAME);
			
			if ((errstr == NULL) || (strlen(errstr) > 0))
			   {
			   syslog(LOG_ERR,errstr,VFQNAME);
			   }
			}
		     
                     break;

   case cferror:
                     printf("%s: %s",VPREFIX,string);

		     if (LOGGING && (getuid() == 0))
			{
			syslog(LOG_ERR,string,VFQNAME);
			}

		     if ((errstr == NULL) || (strlen(errstr) > 0))
                        {
		        printf("%s: %s: %s",VPREFIX,errstr,strerror(errno));
			
			if (LOGGING && (getuid() == 0))
			   {
			   syslog(LOG_ERR,errstr,VFQNAME);
			   syslog(LOG_ERR,strerror(errno),VFQNAME);
			   }
                        }
   }

 
 if (string[strlen(string)-1] != '\n')
    {
    printf("\n");
    }
}
