/* 

        Copyright (C) 1995
        Free Software Foundation, Inc.

   This file is part of GNU cfengine - written and maintained 
   by Mark Burgess, Dept of Computing and Engineering, Oslo College,
   Dept. of Theoretical physics, University of Oslo
 
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA

*/


/*******************************************************************/
/*                                                                 */
/* Errors                                                          */
/*                                                                 */
/*******************************************************************/

#include "cf.defs.h"
#include "cf.extern.h"


FatalError(s)

char *s;

{
fprintf (stderr,"cfengine:%s:%s:%s\n",VPREFIX,VCURRENTFILE,s);
ReleaseCurrentLock();
exit(1);
}

/*********************************************************************/

Warning(s)

char *s;

{
if (WARNINGS)
   { 
   fprintf (stderr,"cfengine:%s:%s:%d: Warning: %s\n",VPREFIX,VCURRENTFILE,LINENUMBER,s);
   }
}

