// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "ivrconfig.h"
#include "bayonne.h"

#pragma pack(1)
typedef	struct
{
	unsigned short port;
	bool detach;
	char cmd[256 - sizeof(short) - sizeof(bool)];
} tgicmd_t;

typedef	struct
{
	time_t update;
	unsigned char ports;
	char name[16];
	char stat[255];
} node_t;

#pragma pack()

// these classes generally are not accessed  outside of the server image
// itself and so are not "exposed" through the bayonne header file.

class Scheduler : public Thread, public ThreadLock
{
private:
	ifstream sched;
	int interval, rtmp;
	int Load(void);
	void Initial(void);
	void Update(void);
	void Run(void);

public:
	Scheduler();
	~Scheduler();

	void Stop(void);
};

// the network service thread.

class Network : public Thread, public UDPSocket, public MappedFile
{
private:
	statnode_t *map;
	time_t last;
	char *getPath(void);
	statnode_t *getNode(const char *name);
	struct sockaddr bcast;
	struct sockaddr_in *broadcast;

	void Initial(void);
	void Run(void);

public:
	Network();

	bool Query(unsigned adapter, void *buf, size_t len);
	void Stop(void);
	void Refresh(int secs);
};

// the resolver is an optional service thread.

class Resolver : public Server
{
private:
	static bool instance;
	time_t interval;

	void Run(void);
	void Stop(void);

public:
	Resolver();
};

#define	SYM_ANNOTATION	"annotation"
#define	SYM_PLAYED	"played"
#define	SYM_RECORDED	"recorded"
#define	SYM_CREATED	"created"
#define	SYM_EXTENSION	"extension"
#define	SYM_LANGUAGE	"language"
#define	SYM_TRIM	"trim"
#define	SYM_VOICE	"voice"
#define	SYM_VOLUME	"volume"
#define	SYM_FORMAT	"format"
#define	SYM_ERROR	"error"
#define	SYM_CALLERTYPE	"callertype"
#define	SYM_CALLERNAME	"callername"
#define	SYM_CALLER	"caller"
#define	SYM_RINGID	"ringid"

extern Network network;
extern Scheduler scheduler;
extern int tgipipe[2];
extern int mainpid;
