// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "server.h"

bool Trunk::scrRecord(void)
{
	data.record.name = getValue("");	
	if(!data.record.name)
	{
		Error("record-no-file");
		return true;
	}

	data.record.timeout = (timeout_t)getTimeout() * 1000l;
	data.record.term = getDigitMask();
	data.record.offset = 0;
	data.record.volume = atoi(getSymbol("volume"));
	data.record.trim = atoi(getSymbol("trim"));
	data.record.append = false;
	TrunkStep(TRUNK_STEP_RECORD);
	return false;
}

bool Trunk::scrAppend(void)
{
	data.record.name = getValue("");	
	if(!data.record.name)
	{
		Error("append-no-file");
		return true;
	}

	data.record.timeout = (timeout_t)getTimeout() * 1000l;
	data.record.term = getDigitMask();
	data.record.offset = 0;
	data.record.volume = atoi(getSymbol("volume"));
	data.record.trim = atoi(getSymbol("trim"));
	data.record.append = true;
	TrunkStep(TRUNK_STEP_RECORD);
	return false;
}

bool Trunk::scrTransfer(void)
{
	strstream str(data.dialxfer.digits, sizeof(data.dialxfer.digits) - 1); 
	char *cp;

	while(NULL != (cp = getValue(NULL)))
		str << cp;

	str << ends;
	data.dialxfer.digits[sizeof(data.dialxfer.digits) - 1] = 0;
	data.dialxfer.interdigit = group->getDialspeed();
	data.dialxfer.digit = data.dialxfer.digits;
	data.dialxfer.exit = true;
	TrunkStep(TRUNK_STEP_DIALXFER);
	return false;
}

bool Trunk::scrSpeak(void)
{
	Translator *tts;
	char *err;

	tts = getTranslator(getSymbol("language"));

	if(!tts)
	{
		Error("language-unsupported");
		return true;
	}
	err = tts->Speak(this);
	if(err)
	{
		Error(err);
		return true;
	}
	while(*data.play.name == ',')
		++data.play.name;

	data.play.volume = atoi(getSymbol("volume"));
	TrunkStep(TRUNK_STEP_PLAY);
	return false;
}
	
bool Trunk::scrDial(void)
{
	strstream str(data.dialxfer.digits, sizeof(data.dialxfer.digits) - 1); 
	char *cp;

	while(NULL != (cp = getValue(NULL)))
		str << cp;

	str << ends;
	data.dialxfer.digits[sizeof(data.dialxfer.digits) - 1] = 0;
	data.dialxfer.interdigit = group->getDialspeed();
	data.dialxfer.digit = data.dialxfer.digits;
	data.dialxfer.exit = false;
	TrunkStep(TRUNK_STEP_DIALXFER);
	return false;
}

bool Trunk::scrPlay(void)
{
	strstream str(data.play.list, sizeof(data.play.list) - 1);
	char *cp;

	while(NULL != (cp = getValue(NULL)))
		str << "," << cp;

	str << ends;
	data.play.list[sizeof(data.play.list) - 1] = 0;
	data.play.name = data.play.list;
	data.play.volume = atoi(getSymbol("volume"));
	while(*data.play.name == ',')
		++data.play.name;

	if(!*data.play.name)
	{
		Error("play-no-files");
		return true;
	}

	data.play.limit = data.play.offset = 0;
	TrunkStep(TRUNK_STEP_PLAY);
	return false;
}	

bool Trunk::scrFlash(void)
{
	data.flash.onhook = atol(getValue(group->getLast("flash")));
	data.flash.offhook = atol(getValue(group->getLast("dialtone")));
	TrunkStep(TRUNK_STEP_FLASH);
	return false;
}

bool Trunk::scrCollect(void)
{
	data.collect.count = atoi(getValue("0"));
	if(data.collect.count > 32)
		data.collect.count = 32;

	data.collect.timeout = getInterdigit() * 1000;
	data.collect.term = getDigitMask();
	data.collect.ignore = getDigitMask();
	TrunkStep(TRUNK_STEP_COLLECT);
	return false;
}

bool Trunk::scrAnswer(void)
{
	data.answer.rings = atoi(getValue("0"));
	data.answer.timeout = atol(getValue(group->getLast("ringtime"))) * 1000;
	TrunkStep(TRUNK_STEP_ANSWER);
	return false;
}	

bool Trunk::scrHangup(void)
{
	if(!Signal((unsigned int)0))
		scrExit();

	return true;
}

bool Trunk::scrAudit(void)
{
	cdrc = 0;
	char *val;

	while(cdrc < 32)
	{
		val = getOption(NULL);
		if(!val)
			break;

		cdrv[cdrc++] = val;
	}
	Advance();
	return true;
}

bool Trunk::scrAlog(void)
{
	char buffer[256];
	strstream str(buffer, 256);
	char *val;

	buffer[0] = 0;
	while(NULL != (val = getValue(NULL)))
		str << val;

	str << endl;
	audit(buffer + 1);
	Advance();
	return true;
}

bool Trunk::scrImport(void)
{
	scriptsymbol_t *sym;
	char *name;
	char *value;

	while(NULL != (name = getOption(NULL)))
	{
		if(*name++ != '%')
			continue;

		value = globals.getSymbol(name);
		if(!value)
			continue;

		setSymbol(name, getSymbolSize());
		setSymbol(name, value);
	}
	Advance();
	return true;
}

bool Trunk::scrDebug(void)
{
	char buf[256];
	char *value;

	buf[0] = 0;
	while(NULL != (value = getValue(NULL)))
		strcat(buf, value);
	debug->DebugScript(this, buf);
	Advance();
	return true;
}

bool Trunk::scrExport(void)
{
	scriptsymbol_t *sym;
	char *name;

	while(NULL != (name = getOption(NULL)))
	{
		if(*name != '%')
			continue;

		sym = getEntry(++name, 0);
		if(!sym)
			continue;

		globals.setSymbol(name, sym->flags.size);
		globals.setSymbol(name, sym->data);
	}
	Advance();
	return true;
}

bool Trunk::scrWait(void)
{
	int timer = atoi(getValue("0"));
	time_t now;

	time(&now);
	timer = timer - (now - start);
	if(timer < 1)
	{
		Advance();
		return true;
	}
	data.sleep.wakeup = timer * 1000;
	data.sleep.rings = atoi(getValue("0"));
	data.sleep.loops = 1;
	TrunkStep(TRUNK_STEP_SLEEP);
	return false;
}

bool Trunk::scrPause(void)
{
	data.sleep.wakeup = atol(getValue("0"));
	data.sleep.loops = 1;
	if(data.sleep.wakeup < 20)
		data.sleep.wakeup = 20;

	data.sleep.rings = 0;
	TrunkStep(TRUNK_STEP_SLEEP);
	return false;
}

bool Trunk::scrDeliver(void)
{
	Module *mod = getModule(MODULE_DELIVERY);
	char *err;

	if(!getOnce())
	{
		Advance();
		return true;
	}
	
	if(!mod)
	{
		Error("no-delivery-protocol");
		return true;
	}

	err = mod->Dispatch(this);
	if(err)
		Error(err);
	else
		Advance();
	return true;
}

bool Trunk::scrSendfile(void)
{
	Module *mod = getModule(MODULE_SENDFILE);
	char *err;

	if(!mod)
	{
		Error("no-sendfile-protocol");
		return true;
	}

	err = mod->Dispatch(this);
	if(err)
		Error(err);
	else
		Advance();
	return true;
}

bool Trunk::scrSendfax(void)
{
	Module *mod = getModule(MODULE_SENDFAX);
	char *err;

	if(!mod)
	{
		Error("no-sendfax-protocol");
		return true;
	}
	
	err = mod->Dispatch(this);
	if(err)
		Error(err);
	else
		Advance();
	return true;
}

bool Trunk::scrNotify(void)
{
	Module *mod = getModule(MODULE_NOTIFY, getValue("*"));
	char *err;

	if(!mod)
	{
		Error("no-notify-module");
		return true;
	}

	err = mod->Dispatch(this);
	if(err)
		Error(err);
	else
		Advance();
	return true;
}	

bool Trunk::scrLibonce(void)
{
	if(getOnce())
		return scrLibexec();

	Advance();
	return true;
}

bool Trunk::scrLibexec(void)
{
	tgicmd_t cmd;
	char query[sizeof(cmd.cmd) / 2];
	strstream str(cmd.cmd, sizeof(cmd.cmd));
	strstream q(query, sizeof(query));
	char *qc;

	int cnt = 0;
	int args = 0;
	data.sleep.wakeup = atoi(getValue("0")) * 1000;
	data.sleep.rings = 0;
	data.sleep.loops = 1;

	cmd.port = id;
	cmd.detach = false;
	cmd.cmd[0] = 0;
	query[0] = 0;
	
	str << getValue("--");
	while(NULL != (qc = getOption(NULL)))
	{
		if(*qc != '%')
			continue;

		if(!query[0])
			q << (qc + 1) << "=" << getContent(qc);
		else
			q << keyserver.getToken() << (qc + 1) << "=" << getContent(qc);
	}
	q << ends;
	str << " query=" << query;
	
	str << " digits=" << dtmf.bin.data;		

	qc = getSymbol("ani");
	if(qc)
		str << " ani=" << qc;

	qc = getSymbol("dnis");
	if(qc)
		str << " dnis=" << qc;

	qc = getSymbol("did");
	if(qc)
		str << " did=" << qc;

	qc = getSymbol("callerid");
	if(qc)
	{
		str << " cid=" << qc;
		qc = getSymbol("callername");
		if(qc)
			str << keyserver.getToken() << qc;
	}

	if(!data.sleep.wakeup)
		cmd.detach = true;

	str << ends;
	::write(tgipipe[1], &cmd, sizeof(cmd));

	if(!data.sleep.wakeup)
	{
		Advance();
		return true;
	}
		
	TrunkStep(TRUNK_STEP_SLEEP);
	return false;
}

bool Trunk::scrLookup(void)
{
	char buffer[256];
	strstream str(buffer, sizeof(buffer));
	unsigned adapter = atoi(getValue("0"));
	char *cp;
	char *opt;

	if(!adapter)
		++tgi.seq;
		
	buffer[0] = 0;
		
	str << "L" << id << '\t' << tgi.seq << '\t' << getValue("default");
	while(NULL != (opt = getOption(NULL)))
	{
		cp = getContent(opt);
		str << '\t' << opt << '=' << cp;
	}
	str << ends;
	buffer[255] = 0;

	if(!network.Query(adapter, buffer, strlen(buffer) + 1))
	{
		Error("lookup-failed");
		return true;
	}
	data.sleep.wakeup = keynetwork.getDatabaseDelay() * 1000;
	data.sleep.rings = 0;
	data.sleep.loops = 1;
	TrunkStep(TRUNK_STEP_SLEEP);
	return false;
}

bool Trunk::scrUpdate(void)
{
	char buffer[256];
	strstream str(buffer, sizeof(buffer));
	unsigned adapter = atoi(getValue("0"));
	char *opt, *cp;

	if(!adapter)
		++tgi.seq;

	buffer[0] = 0;

	str << "U" << id << '\t' << tgi.seq << '\t' << getValue("default");
	while(NULL != (opt = getOption(NULL)))
	{
		cp = getContent(opt);
		str << '\t' << opt << opt << '=' << cp;
	}
	str << ends;
	buffer[255] = 0;

	if(!network.Query(adapter, buffer, strlen(buffer) + 1))
	{
		Error("updated-failed");
		return true;
	}
	data.sleep.wakeup = keynetwork.getDatabaseDelay() * 1000;
	data.sleep.rings = 0;
	data.sleep.loops = 1;
	TrunkStep(TRUNK_STEP_SLEEP);
	return false;
}

bool Trunk::scrTone(void)
{
	phTone *tone = getphTone(getValue(""));
	if(!tone)
	{
		Error("no-tone");
		return true;
	}
	data.tone.tone = tone;
	data.tone.wakeup = atol(getValue("0"));
	data.tone.loops = atoi(getValue("1"));
	TrunkStep(TRUNK_STEP_TONE);
	return false;
}


bool Trunk::scrSleep(void)
{
	int timer = atoi(getValue("0"));

	if(!timer)
	{
		Advance();
		return true;
	}

	data.sleep.wakeup = timer * 1000;
	data.sleep.loops = 1;
	data.sleep.rings = 0;
	TrunkStep(TRUNK_STEP_SLEEP);
	return false;
}

bool Trunk::scrFunction(void)
{
	char *name = getOption(NULL);
	scriptsymbol_t *sym = getEntry(name, getSymbolSize());
	functioncall_t fun = driver->getFunction(name);
	char *argv[32];
	int count = 0;

	if(!fun)
	{
		Error("function-not-found");
		return true;
	}

	if(!sym)
	{
		Error("symbol-not-found");
		return true;
	}

	if(sym->flags.readonly)
	{
		Error("symbol-readonly");
		return true;
	}

	sym->data[sym->flags.size] = 0;
	while(count < 31)
	{
		argv[count] = getValue();
		if(!argv[count])
			break;
		++count;
	}
	argv[count] = NULL;
	name = (*fun)(sym, argv);
	if(name)
		Error(name);
	else
	{
		sym->flags.initial = false;
		if(sym->flags.commit)
			Commit(sym);
		Advance();
	}
	return true;
}
