// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <ivrconfig.h>
#include <bayonne.h>
#include <vpbapi.h>
#include <cc++/audio.h>

class VPBTrunk;
class VPBThread;

typedef bool (VPBTrunk::*trunkhandler_t)(TrunkEvent *event);

class VPBTrunk: private TimerPort, private Trunk
{
private:
	friend class VPBDriver;
	friend class VPBThread;

	static char status[16 * 4];

	int handle;
	time_t lastring;
	trunkhandler_t handler;
	VPBThread *service;
	trunkevent_t notify;
	
	VPBTrunk(VPBThread *thread, int ts);
	~VPBTrunk();

	void getName(char *buffer);
	unsigned long getIdleTime(void);
	
	bool stepHandler(TrunkEvent *event);
	bool busyHandler(TrunkEvent *event);
	bool idleHandler(TrunkEvent *event);
	bool seizeHandler(TrunkEvent *event);
	bool ringHandler(TrunkEvent *event);
	bool waitHandler(TrunkEvent *event);
	bool dialHandler(TrunkEvent *event);
	bool playHandler(TrunkEvent *event);
	bool recordHandler(TrunkEvent *event);
	bool sleepHandler(TrunkEvent *event);
	bool hangupHandler(TrunkEvent *event);
	bool answerHandler(TrunkEvent *event);
	bool collectHandler(TrunkEvent *event);
	bool flashonHandler(TrunkEvent *event);
	bool flashoffHandler(TrunkEvent *event);

	void setTimer(timeout_t timeout = 0, trunkevent_t notice = TRUNK_TIMER_EXPIRED);
	void setOffhook(void);

	bool postEvent(TrunkEvent *event);
	void Exit(void);
	void TrunkStep(trunkstep_t step);
};

class VPBRecord: private AudioFile, public Service
{
private:
	bool reset;
	size_t bufsize, samples;
	int handle;

	void Initial(void);
	void Run(void);

public:
	VPBRecord(VPBTrunk *trunk, int h);
	~VPBRecord();
};

class VPBPlay : private AudioFile, public Service
{
private:
	bool reset;
	size_t bufsize, samples;
	int handle;

	void Initial(void);
	void Run(void);
	char *getContinuation(void);

public:
	VPBPlay(VPBTrunk *trunk, int h);
	~VPBPlay();
};

class VPBConfig : public Keydata
{
public:
	VPBConfig();

	int getOffset(void)
		{return strtol(getLast("first"), NULL, 16);};

	int getCards(void)
		{return atoi(getLast("cards"));};

	int getHookTimer(void)
		{return atoi(getLast("hooktime"));};

	const char *getFirmware(void)
		{return getLast("firmware");};
	
};

class VPBThread : public Mutex, public Thread
{
private:
	friend class VPBDriver;
	friend class VPBTrunk;

	static int count; 
	volatile bool active;

	int id;
	VPBTrunk *handles[4];
	void *reg;

	void Run(void);
	VPBThread();
	~VPBThread();
};

class VPBDriver : public Driver, public VPBConfig
{
private:
	VPBThread *threads;
	VPBTrunk **ports;
	int port_count, thread_count;

public:
	VPBDriver();
	~VPBDriver();

	int Start(void);
	void Stop(void);

	int getTrunkCount(void)
		{return port_count;};

	Trunk *getTrunkPort(int id);
	aaScript *getScript(void);
};

extern VPBDriver vpbivr;
