// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

VPBConfig::VPBConfig() :
Keydata("/bayonne/vpb")
{
	static KEYDEF defkeys[] = {
	{"cards", "1"},
	{"first", "300"},
	{"hooktime", "300"},
	{"firmware", "/etc/vpbmain.out"},
	{NULL, NULL}};

	Load(defkeys);
}

VPBDriver::VPBDriver() :
Driver()
{
	threads = NULL;
	port_count = getCards() * 4;
	status = VPBTrunk::status;

	ports = new VPBTrunk *[port_count];
	groups = new TrunkGroup *[port_count];
	memset(ports, 0, sizeof(VPBTrunk *) * port_count);
	memset(groups, 0, sizeof(TrunkGroup *) * port_count);

	memset(status, ' ', sizeof(VPBTrunk::status));
	if(getuid())
	{
		slog(SLOG_CRITICAL) << "vpb driver requires root" << endl;
		throw((Driver *)this);
	}
	slog(SLOG_INFO) << "vpb driver loaded; capacity=" << getCards() << " cards" << endl;
}

VPBDriver::~VPBDriver()
{
	Stop();
	if(ports)
		delete ports;

	if(groups)
		delete groups;
}

int VPBDriver::Start(void)
{
	int count, ts;
	int cards = getCards();
	int offsets[16];
	int first = getOffset();

	// assume from port 0x3x0 upward

	for(count = 0; count < cards; ++count)
		offsets[count] = first + 16 * count; 

	if(active)
	{
		slog(SLOG_ERROR) << "vpb: driver already started" << endl;
		return 0;
	}

	vpb_start(cards, offsets, (char *)getFirmware());

	threads = new VPBThread[cards];

	for(count = 0; count < cards; ++count)
		for(ts = 0; ts < 4; ++ts)
			ports[count * 4 + ts] = new VPBTrunk(&threads[count], ts);

	for(count = 0; count < cards; ++count)
		threads[count].Start();

	slog(SLOG_INFO) << "vpb: initalized " << cards * 4 << " ports successfully..." << endl;
	active = true;
	return cards * 4;
}

void VPBDriver::Stop(void)
{
	unsigned port;

	if(!active)
		return;

	for(port = 0; port < port_count; ++port)
		if(ports[port])
			delete ports[port];

	if(threads)
	{
		slog(SLOG_INFO) << "vpb: threads exiting..." << endl;
		delete[] threads;
		threads = NULL;
	}

	if(ports)
	{
		delete ports;
		ports = NULL;
	}
	vpb_stop();
	active = false;
	slog(SLOG_INFO) << "vpb: stopping..." << endl;
}

Trunk *VPBDriver::getTrunkPort(int id)
{
	if(id < 0 || id >= port_count)
		return NULL;

	if(!ports)
		return NULL;

	return (Trunk *)ports[id];
}

VPBDriver vpbivr;
