// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of Bayonne as noted here.
//
// This exception is that permission is hereby granted to link Bayonne 
// with  the Pika MonteCarlo libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name Bayonne.  If you copy code from other releases into a copy of
// Bayonne, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to Bayonne, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include <bayonne.h>

class AppendAudit : public Audit
{
private:
	void Report(char *detail);
	void Stats(void);
	char logpath[256];

public:
	AppendAudit();

} myappend;

AppendAudit::AppendAudit() :
Audit()
{
	const char *fp = keys.getLast("logfile");
	if(fp)
		strcpy(logpath, fp);
	else
	{
		fp = keys.getLast("logpath");
		if(!fp)
			fp = "/var/log";

		strcpy(logpath, fp);
		strcat(logpath, "/bayonne.audit");
	}
	slog(SLOG_INFO) << "audit: append=" << logpath << endl;
}

void AppendAudit::Stats(void)
{
	int fd = -1;
	const char *fp = keys.getLast("statfile");
	char name[512];
	strstream str(name, 512);
	time_t now;
	struct tm *dt;
	time(&now);
	now = now / 300 * 300;
	dt = localtime(&now);
	long incoming, outgoing, maxincoming, maxoutgoing;

	if(fp)
		strcpy(name, fp);
	else
	{
		fp = keys.getLast("logpath");
		if(!fp)
			fp = "/var/log";

		strcpy(logpath, fp);
		strcat(logpath, "/bayonne.stats");
	}

	TrunkGroup *group = getFirst();
	while(group)
	{
		if(!group->getCapacity())
		{
			group = getNext(group);
			continue;
		}
		group->Update();
		incoming = group->getStat(STAT_TOT_INCOMING);
		outgoing = group->getStat(STAT_TOT_OUTGOING);

		if(!incoming && !outgoing)
		{
			group = getNext(group);
			continue;
		}

		maxincoming = group->getStat(STAT_MAX_INCOMING);
		maxoutgoing = group->getStat(STAT_MAX_OUTGOING);

		if(fd < 0)
		{
			fd = open(name, O_CREAT | O_WRONLY | O_APPEND, 0600);
			if(fd < 0)
				break;
	
			sprintf(name, "%04d%02d%02d %02d:%02d:%02d",
				dt->tm_year + 1900, dt->tm_mon + 1, dt->tm_mday,
				dt->tm_hour, dt->tm_min, dt->tm_sec);

			write(fd, name, strlen(name));
			name[0] = 0;
		}
		str << " " << group->getName() << "=";
		str << group->getCapacity() << "/";
		str << maxincoming << "/";
		str << maxoutgoing << "/";
		str << incoming << "/";
		str << outgoing;
		group = getNext(group);
	}
	if(fd > 0)
	{
		str << '\n' << ends;
		write(fd, name, strlen(name));
		close(fd);
	}
}

void AppendAudit::Report(char *detail)
{
	int fd = open(logpath, O_WRONLY | O_APPEND | O_CREAT, 0600);
	
	if(fd < 0)
	{
		if(getppid() != 1)
			slog(SLOG_INFO) << "audit: " << detail << ends;
		return;
	}

	write(fd, detail, strlen(detail));
	close(fd);
}
