#if 0
// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of Bayonne as noted here.
//
// This exception is that permission is hereby granted to link Bayonne 
// with  the Pika MonteCarlo libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name Bayonne.  If you copy code from other releases into a copy of
// Bayonne, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to Bayonne, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".
#endif

#include "ioports.h"

#ifdef	HAVE_SYS_IO_H
#include <sys/io.h>
#else
#ifdef	HAVE_ASM_IO_H
#include <asm/io.h>
#endif
#endif

#ifndef	__alpha__

static __inline__ void _outb(int value, int port)
{
	__asm__ volatile ("outb %0,%1"
		::"a" ((unsigned char)value), "d"((unsigned short) port));
}

static __inline__ void _outw(int value, int port)
{
	__asm__ volatile ("outw %0,%1"
		::"a" ((unsigned short)value), "d"((unsigned short)port));
}

static __inline__ int _inb(int port)
{
	unsigned char value;
	__asm__ volatile ("inb %1,%0"
		:"=a" (value)
		:"d"((unsigned short) port));
	return value;
}

static __inline__ int _inw(int port)
{
	unsigned short value;
	__asm__ volatile ("inw %1,%0"
		:"=a" (value)
		:"d"((unsigned short) port));
	return value;
}

#endif

void ioread(unsigned port, unsigned short *addr, unsigned len)
{
	while(len--)
		*(addr++) = _inw(port);
}
	
void iowrite(unsigned port, unsigned short *addr, unsigned len)
{
	while(len--)
		_outw(*addr++, port);
}

void ioset(unsigned port, unsigned short value)
{
	if(port % 2)
		_outb(value, port);
	else
		_outw(value, port);
}

int iopriv(int flag)
{
	if(flag)
		return iopl(3);
	else
		return iopl(0);
}



