// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of Bayonne as noted here.
//
// This exception is that permission is hereby granted to link Bayonne 
// with  the Pika MonteCarlo libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name Bayonne.  If you copy code from other releases into a copy of
// Bayonne, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to Bayonne, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include "driver.h"
#include "ioports.h"

VPBConfig::VPBConfig() :
Keydata("/bayonne/vpb")
{
	static KEYDEF defkeys[] = {
	{"first", "300"},
	{"cards", "1"},
	{"channels", "4"},
	{"messagesize", "128"},
	{"transmitsize", "1000"},
	{"receivesize", "1000"},
	{"framesize", "160"},
	{"relaysize", "16000"},
	{"firmware", "/etc/vpbmain.out"},
	{NULL, NULL}};

	Load(defkeys);
}

VPBDriver::VPBDriver() :
Driver()
{
	threads = NULL;
	ports = NULL;
	groups = NULL;
	port_count = 0;

	if(getuid())
	{
		slog(SLOG_CRITICAL) << "vpb driver requires root" << endl;
		throw((Driver *)this);
	}
	slog(SLOG_INFO) << "vpb driver loaded; capacity=" << getCards() << " cards" << endl;
}

VPBDriver::~VPBDriver()
{
	Stop();
	if(ports)
		delete ports;

	if(groups)
		delete groups;
}

int VPBDriver::Start(void)
{
	int count = 0;
	int cards = getCards();

	if(active)
	{
		slog(SLOG_ERROR) << "vpb: driver already started" << endl;
		return 0;
	}

	if(iopriv(1))
	{
		slog(SLOG_CRITICAL) << "vpb: cannot access io ports" << endl;
		return 0;
	}

	threads = new VPBThread[cards];

	slog(SLOG_INFO) << "vpb: initalized " << VPBThread::cards << " of " << VPBThread::count << " card(s) successfully..." << endl;
	active = true;
	return count;
}

void VPBDriver::Stop(void)
{
	if(!active)
		return;

	if(threads)
	{
		slog(SLOG_INFO) << "vpb: threads exiting..." << endl;
		delete threads;
		threads = NULL;
	}

	iopriv(0);

	if(ports)
	{
		delete ports;
		ports = NULL;
	}

	active = false;
	slog(SLOG_INFO) << "vpb: stopping..." << endl;
}

Trunk *VPBDriver::getTrunkPort(int id)
{
	if(id < 0 || id >= port_count)
		return NULL;

	if(!ports)
		return NULL;

	return (Trunk *)ports[id];
}

VPBDriver vpbivr;
