Summary: bayonne - the telephony server of the GNU project
Name: bayonne
Version: 0.3.3
Release: 2
Group: System Environment/Daemons
Source: ftp://www.voxilla.org/pub/bayonne/bayonne-%{PACKAGE_VERSION}.tar.gz
Prefix: /usr
Vendor: Open Source Telecom
Copyright: GPL
BuildRoot: %{_tmppath}/bayonne-root
Packager: David Sugar <dyfet@ostel.com>
url: http://www.bayonne.cx

%description
Bayonne offers a script programmable modular server for deploying
multi-line telephony voice response and computer telephony applications.

%package UsEngM
Summary: bayonne-UsEngM - voice library for US English Male speaker
Group: System Environment/Daemons
Requires: bayonne

%package drivers
Summary: bayonne telephony device drivers
Group: System Enviornment/Daemons
Requires: bayonne

%description drivers
The actual set of device drivers that may be built from Bayonne depends
on which telephony API's are found on the build host by "configure".  Some
Bayonne driver dso's are always built for all GNU/Linux systems, such as
phonedev or dummy.  Others, like the Pika driver, require the MonteCarlo
API.  Unfortunately there is no support in RPM packages for conditionally
building a subpackage based on the presense or absence of a dependent
library.  Hence, the drivers package will contain those drivers that were
buildable on the build host rather than those that might be supported on
the end user's target system.  Ideally the build host that was used to
prepare this package in binary form should contain all possible telephony
api packages that Bayonne will support.

%description UsEngM
The US English "male" speaker library offers default voice prompts
for the Bayonne telephony server.

%prep
rm -rf $RPM_BUILD_ROOT

%setup

# NOTE: in Common C++, compiler options are retreived from config.def
# and should not be overriden here!

./configure --prefix=%{prefix} --sysconfdir=/etc

%build
uname -a|grep SMP && make -j 2 || make

%install
mkdir -p $RPM_BUILD_ROOT/var/bayonne
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
make prefix=$RPM_BUILD_ROOT/%{prefix} sysconfdir=$RPM_BUILD_ROOT/etc install

%files
%defattr(-,root,root,0755)
%doc AUTHORS COPYING NEWS README TODO DRIVERS.TXT PROMPTS.TXT SCRIPT.TXT ChangeLog
%config %attr(0600,root,root) /etc/bayonne.conf
%config %attr(0600,root,root) /etc/bayonne.sched
%dir /usr/share/aaprompts
/etc/rc.d/init.d/bayonne
/usr/man/man8/bayonne.8
/usr/libexec/tgi
/usr/libexec/bayonne/*.aud
/usr/libexec/bayonne/*.fun
/usr/libexec/bayonne/*.dbg
/usr/libexec/bayonne/*.tts
/usr/libexec/bayonne/*.mon
/usr/share/aascripts
/usr/sbin/bayonne
/var/bayonne

%files drivers
/usr/libexec/bayonne/*.ivr

%files UsEngM
/usr/share/aaprompts/UsEngM

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/chkconfig --add bayonne

%preun
/sbin/chkconfig --del bayonne

