/************************************************************************/
/* File		standards.h						*/
/*									*/
/* Purpose	This C++ header file is the standard header file for	*/
/*		the Genereal Purpose C++ Programming Toolkit by Padre	*/
/*		Software. The standard header file defines the standard	*/
/*		constants that are used by the toolkit library classes.	*/
/*		The standard constants are TRUE and FALSE, OK and	*/
/*		ERROR, and LESS, EQUAL, MORE.				*/
/*									*/
/* Author	This C++ header file was written by Charles Henry	*/
/*		Schoonover for Padre Software. You can contact Charles	*/
/*		Henry Schoonover at charles@padresoftware.com.		*/
/*									*/
/* Owner	The contents of this C++ header file were written for	*/
/*		Padre Software. You can contact Padre Software at	*/
/*		webmaster@padresoftware.com.				*/
/*									*/
/* Version	0.0.0 (Prototype)					*/
/*									*/
/* Date		Sunday, April 28, 2002.					*/
/*									*/
/* Copyright	(C) 2002 by Padre Software Incorporated.		*/
/*		All rights are reserved.				*/
/*									*/
/*		Padre Software has released the source code in this	*/
/*		file to the public domain under the terms of the GNU	*/
/*		General Public License. (See the file COPYING).		*/
/*									*/
/*		This program is free software; you can redistribute it	*/
/*		and/or modify it under the terms of the GNU General	*/
/*		Public License as published by the Free Software	*/
/*		Foundation; either version 2 of the License, or (at	*/
/*		your option) any later version.				*/
/************************************************************************/

#ifndef STANDARDS_H			// If not defined...
#define STANDARDS_H			// Then process header file.

/* Typedef	The following typedef and constants define the		*/
/*		condition type. The condition type can be used to	*/
/*		determine if a condition is TRUE or FALSE.		*/

typedef bool condition;

/* Enumeration	The following enumberation defines a type called	*/
/*		'status'. The 'status' type can be used to determine	*/
/*		if an error has occurred.				*/

enum status
   {
      OK		= 0,
      ERROR		= -1
   };

/* Enumberation	The following enumeration defines a type called		*/
/*		'relation'. The 'relation' type can be used to		*/
/*		determine the relation between two objects.		*/

enum relation
   {
      LESS		= -1,
      EQUAL		= 0,
      MORE		= 1
   };

#endif					// STANDARDS_H
