/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifndef _robots_h
#define _robots_h

#include <webbase_url.h>
#include <webbase.h>

#ifdef __cplusplus
extern "C" {
#endif

#define ROBOTS_NOT_DELAYED	0
#define ROBOTS_DELAYED		1

#define ROBOTS_ALLOWED		1
#define ROBOTS_NOT_ALLOWED	0

#define ROBOTS_INFO_USED	1

#define ROBOTS_OPTIONS		0x0008000

typedef struct robots_entry {
  int rowid;
  int info;

  char netloc[WEBBASE_URL_LENGTH + 1];

  int allow_size;
  char* allow;
  int disallow_size;
  char* disallow;

  int next_crawl;
  int queue_crawl;

} robots_entry_t;

typedef struct robots {
  /* Public */
  hash_t* options;

  robots_entry_t current;

  webbase_t* base;
} robots_t;

#include <crawl_private.h>
#include <crawl.h>

struct option* robots_options(struct option options[]);
robots_t* robots_alloc(int argc, char** argv, struct option options[]);
void robots_load(robots_t* robots, crawl_context_t* context, char* url);
int robots_server_id(robots_t* robots);
int robots_url2server_id(webbase_t* base, char* url);
void robots_info(robots_t* robots, int robot_delay, uri_t* url_object, time_t* delay, int* delayed);
void robots_free(robots_t* params);
int robots_p(char* path);

#ifdef __cplusplus
}
#endif

#endif /* _robots_h */
