/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifndef _cookies_h
#define _cookies_h

#include <webbase_url.h>
#include <webbase.h>

#ifdef __cplusplus
extern "C" {
#endif

#define COOKIES_INFO_IN_BASE	0x01
#define COOKIES_INFO_CHANGED	0x02

#define COOKIES_OPTIONS		0x0010000

#define COOKIES_LENGTH		255

typedef struct cookies_entry {
  int info;

  char netloc[WEBBASE_URL_LENGTH + 1];
  char path[WEBBASE_URL_LENGTH + 1];
  time_t expires;
  char in[COOKIES_LENGTH + 1];
  char out[COOKIES_LENGTH + 1];
} cookies_entry_t;

typedef struct cookies {
  /* Public */
  hash_t* options;

  cookies_entry_t current;
  char netloc_without_cookies[WEBBASE_URL_LENGTH + 1];

  webbase_t* base;
} cookies_t;

struct option* cookies_options(struct option options[]);
cookies_t* cookies_alloc(int argc, char** argv, struct option options[]);
void cookies_load(cookies_t* cookies, char* url, char* cookie);
char* cookies_match(cookies_t* cookies, uri_t* url_object);
void cookies_free(cookies_t* params);

#ifdef __cplusplus
}
#endif

#endif /* _cookies_h */
