/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifndef _hrefparse_h
#define _hrefparse_h

#include <webbase_url.h>

#define HREFPARSE_SOURCE_FILENAME	1
#define HREFPARSE_SOURCE_STRING		2

#define HREFPARSE_KEEP_RELATIVE		0
#define HREFPARSE_STRIP_RELATIVE	1

/*
 * Read HTML file 'filename' and extract hypertext links, ignoring relative
 * links if 'strip_relative' is not null and return the list of hypertext
 * links found in the 'hrefs' variable.
 * The first element of the 'hrefs' string table is called the BASE (see
 * HTML specification). It defaults to the URL of the page or to the
 * value of the BASE tag if any.
 */
void hrefparse_init();
int hrefparse(char* source, int string_or_filename, int strip_relative, webbase_url_t* webbase_url, int size_limit);

#endif /* _hrefparse_h */
