<?php /* Copyright (C) 2008 David Englund.

This file is part of GNU Sovix.

GNU Sovix is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

GNU Sovix is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with GNU Sovix.  If not, see <http://www.gnu.org/licenses/>.

The text in $sovix__page__copyright doesn't apply to this file, but
rather to the pages it generates. */

$sovix__page__copyright="Copyright (C) 2008 David Englund.
Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.3 or any
later version published by the Free Software Foundation; with no Invariant
Sections, with no Front-Cover Texts, and with no Back-Cover Texts.";
$sovix__directory__src=$_SERVER['DOCUMENT_ROOT']."/sovix/src";
$sovix__directory__dotsovix=$_SERVER['DOCUMENT_ROOT']."/sovix/dotsovix";
require_once "$sovix__directory__src/header.inc"; ?>

<p>This document is an attempt to gather the known techniques to serve XHTML documents following the <a href="http://www.w3.org/TR/xhtml1/#guidelines">backwards compatibility guidelines</a> as both <code>text/html</code> and <code>application/xhtml+xml</code> with content-negotiation, thus allowing browsers that do not understand the newest MIME-type to get a version with a MIME-type they understand.</p>
<p>This is a work in progress. Please send your comments and suggestions to &lt;<a href="mailto:www-qa@sovix.org">www-qa@sovix.org</a>&gt;</p> 

<?php if ($sovix__xhtml_basic!=true) echo "<hr$sovix__close_tag>"; ?>

<p>
Close tag:
<span style="color:#0000BB">&lt;?php&nbsp;</span><span style="color:#007700">echo&nbsp;</span><span style="color:#0000BB">$sovix__close_tag</span><span style="color:#007700">;&nbsp;</span><span style="color:#0000BB">?&gt;</span>
</p>

<p>
Example:
&lt;br<span style="color:#0000BB">&lt;?php&nbsp;</span><span style="color:#007700">echo&nbsp;</span><span style="color:#0000BB">$sovix__close_tag</span><span style="color:#007700">;&nbsp;</span><span style="color:#0000BB">?&gt;</span>&gt;
</p>
<?php if ($sovix__xhtml_basic!=true) echo "<hr$sovix__close_tag>"; ?>

<p>
Horizontal rule:
<span style="color:#0000BB">&lt;?php&nbsp;</span><span style="color:#007700">if&nbsp;(</span><span style="color:#0000BB">$sovix__xhtml_basic</span><span style="color:#007700">!=</span><span style="color:#0000BB">true</span><span style="color:#007700">)&nbsp;echo&nbsp;</span><span style="color:#DD0000">"&lt;hr$sovix__close_tag&gt;"</span><span style="color:#007700">;&nbsp;</span><span style="color:#0000BB">?&gt;<br<?php echo $sovix__close_tag; ?>></span>
</p>
<?php if ($sovix__xhtml_basic!=true) echo "<hr$sovix__close_tag>"; ?>

<p>
cellspacing, cellspacing:
<span style="color:#0000BB">&lt;?php&nbsp;</span><span style="color:#007700">if&nbsp;(</span><span style="color:#0000BB">$sovix__xhtml_basic</span><span style="color:#007700">!=</span><span style="color:#0000BB">true&nbsp;</span><span style="color:#007700">&amp;&amp;&nbsp;</span><span style="color:#0000BB">$sovix__xhtml_print</span><span style="color:#007700">!=</span><span style="color:#0000BB">true</span><span style="color:#007700">)&nbsp;echo&nbsp;</span><span style="color:#DD0000">'&nbsp;cellpadding="0"&nbsp;cellspacing="0"'</span><span style="color:#007700">;&nbsp;</span><span style="color:#0000BB">?&gt;</span>
</p>

<p>
Example: &lt;table<span style="color:#0000BB">&lt;?php&nbsp;</span><span style="color:#007700">if&nbsp;(</span><span style="color:#0000BB">$sovix__xhtml_basic</span><span style="color:#007700">!=</span><span style="color:#0000BB">true&nbsp;</span><span style="color:#007700">&amp;&amp;&nbsp;</span><span style="color:#0000BB">$sovix__xhtml_print</span><span style="color:#007700">!=</span><span style="color:#0000BB">true</span><span style="color:#007700">)&nbsp;echo&nbsp;</span><span style="color:#DD0000">'&nbsp;cellspacing="0"&nbsp;cellpadding="0'"</span><span style="color:#007700">;&nbsp;</span><span style="color:#0000BB">?&gt;</span>&gt;
</p>

<?php require_once "$sovix__directory__src/footer.inc"; ?>
