/* Source Installer, Copyright (c) 2005-2006 Claudio Fontana

 console.c - pseudo-console implementation

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#include "global.h"
#include "gui.h"

#include "greeting.h"
#include "package_info.h"
#include "text.h"
#include "status.h"
#include "menu.h"
#include "console.h"


GtkWidget* w_console[W_CONSOLE_N];

void console_create(void) {

  /* console */
  w_console[W_CONSOLE_LBL] = gtk_label_new(NULL);
  gtk_label_set_markup(GTK_LABEL(w_console[W_CONSOLE_LBL]), "Information");
  
  /* console */
  w_console[W_CONSOLE_TXT] = text_new();

  gtk_text_view_set_editable(GTK_TEXT_VIEW(w_console[W_CONSOLE_TXT]), FALSE);
  gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(w_console[W_CONSOLE_TXT]), GTK_WRAP_CHAR);
  gtk_text_view_set_left_margin(GTK_TEXT_VIEW(w_console[W_CONSOLE_TXT]), bw);
  gtk_text_view_set_right_margin(GTK_TEXT_VIEW(w_console[W_CONSOLE_TXT]), bw);

  w_console[W_CONSOLE] = gtk_scrolled_window_new(NULL, NULL);
  gtk_container_set_border_width(GTK_CONTAINER(w_console[W_CONSOLE]), bw);

  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(w_console[W_CONSOLE]),
				 GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
  
  gtk_container_add(GTK_CONTAINER(w_console[W_CONSOLE]), w_console[W_CONSOLE_TXT]);
}

void console_show(void) {
  if (!GTK_WIDGET_VISIBLE(w_console[W_CONSOLE]))
    gtk_widget_show_all(w_console[W_CONSOLE]);
  greeting_hide();
  package_info_hide();
  gui_update();
}

void console_hide(void) {
  if (GTK_WIDGET_VISIBLE(w_console[W_CONSOLE]))
    gtk_widget_hide_all(w_console[W_CONSOLE]);
}

void console_clear(void) {
  GtkTextBuffer* txt;
  GtkTextIter start;
  GtkTextIter end;

  txt = gtk_text_view_get_buffer(GTK_TEXT_VIEW(w_console[W_CONSOLE_TXT]));
  gtk_text_buffer_get_start_iter(txt, &start);
  gtk_text_buffer_get_end_iter(txt, &end);

  gtk_text_buffer_delete(txt, &start, &end);
}

void console_print(char* s, int tidx) {
  GtkAdjustment* ad;
  int maybe_scroll; gdouble value;

  gui_doevents(0);

  ad = gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(w_console[W_CONSOLE]));

  value = gtk_adjustment_get_value(ad);
  maybe_scroll = (ad->upper - value <= ad->page_size);

  text_print(GTK_TEXT_VIEW(w_console[W_CONSOLE_TXT]), s, tidx);
  
  gui_doevents(0);

  if (maybe_scroll) {
    GtkTextBuffer* buf;
    GtkTextIter end;
    
    buf = gtk_text_view_get_buffer(GTK_TEXT_VIEW(w_console[W_CONSOLE_TXT]));
    gtk_text_buffer_get_end_iter(buf, &end);

    gtk_text_view_scroll_to_iter(GTK_TEXT_VIEW(w_console[W_CONSOLE_TXT]),
				 &end, 0.1, FALSE, 0.0, 0.0);
  }
}

void console_print_size(off_t size, int tidx) {
  char buffer[1024];

  sprintf(buffer, OFF_FMT, size);
  console_print(buffer, tidx);
}

void console_print_stdout(char* s) {
  /* callback called from libsrcinst */
  status_pulse();  
  console_print(s, TAG_STDOUT);
  console_print("\n", TAG_NONE);
}

void console_print_stderr(char* s) {
  /* callback called from libsrcinst */
  /* status_pulse(); */
  console_print(s, TAG_STDERR);
  console_print("\n", TAG_NONE);
}

void console_print_spawn(char* s) {
  /* callback called from libsrcinst */
  status_pulse();
  status_command(s);
  console_print("$ ", TAG_SPAWN);
  console_print(s, TAG_SPAWN);
  console_print("\n", TAG_NONE);
}

int console_savelog(char* filename) {
  FILE* f; GtkTextBuffer* buf; GtkTextIter start, end;
  char* txt; size_t len; int rv;

  if (!(f = fopen(filename, "w")))
    return 0;

  buf = gtk_text_view_get_buffer(GTK_TEXT_VIEW(w_console[W_CONSOLE_TXT]));
  gtk_text_buffer_get_start_iter(buf, &start);
  gtk_text_buffer_get_end_iter(buf, &end);

  len = strlen(txt = gtk_text_buffer_get_text(buf, &start, &end, FALSE));
    
  rv = (fwrite(txt, 1, len, f) == len);

  free(txt);

  if (fclose(f) == EOF)
    return 0;

  return rv;
}

void console_populate_popup(GtkTextView* tv, GtkMenu* menu, gpointer unused) {
  GtkWidget* sep; sep = gtk_separator_menu_item_new();
  GtkWidget* save_log;

  save_log = gtk_image_menu_item_new_with_mnemonic("_Save log");
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(save_log), gtk_image_new_from_stock(GTK_STOCK_SAVE, GTK_ICON_SIZE_MENU));

  if (state.actions_locked) {
    gtk_widget_set_sensitive(save_log, FALSE);

  } else {
    g_signal_connect(G_OBJECT(save_log), "activate",
		     G_CALLBACK(gui_action_savelog), NULL);
  }

  gtk_menu_shell_prepend(GTK_MENU_SHELL(menu), sep);
  gtk_menu_shell_prepend(GTK_MENU_SHELL(menu), save_log);
  gtk_widget_show_all(GTK_WIDGET(menu));
}
