/* Source Installer, Copyright (c) 2005,2006,2007 Claudio Fontana

   srcalloc.c - simple wrappers for heap allocation functions

   This program is free software; you can redistribute it and/or modify
       it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
       (at your option) any later version.

   This program is distributed in the hope that it will be useful,
       but WITHOUT ANY WARRANTY; without even the implied warranty of
       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
       GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
       along with this program (look for the file called COPYING);
       if not, write to the Free Software Foundation, Inc.,
           51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

       You can contact the author (Claudio Fontana) by sending a mail
       to claudio@gnu.org
*/

#include "src_stdinc.h"
#define STRJOIN_MAX 64

void* srcinst_malloc(size_t s) {
  void* p = malloc(s);

  if (!p) {
    srcinst_error(SRCINST_ERR_HEAP, "malloc failed", 0);
  }

  return p;
}

void* srcinst_realloc(void* p, size_t s) {
  if (!(p = realloc(p, s))) {
    srcinst_error(SRCINST_ERR_HEAP, "realloc failed", 0);
  }

  return p;
}

char* srcinst_strdup(char* s) {

  if (!(s = strdup(s))) {
    srcinst_error(SRCINST_ERR_HEAP, "strdup failed", 0);
  }

  return s;
}

static char* _strjoin_aux(char* args, va_list ap) {
  char* strings[STRJOIN_MAX];
  size_t ptrs[STRJOIN_MAX];

  int i, argc; size_t len; char* rv;

  len = argc = 0;
  
  while (args && argc < STRJOIN_MAX) {
    strings[argc] = args;
    ptrs[argc] = len;

    len += strlen(args); argc++;
    args = va_arg(ap, char*);
  }

  rv = srcinst_malloc(len + 1);
  *rv = 0;
  
  for (i = 0; i < argc; i++) 
    strcpy(rv + ptrs[i], strings[i]);

  return rv;
}

/* remember a zero as the last argument */

char* srcinst_strjoin(char* args, ...) {
  va_list ap; char* rv;

  va_start(ap, args);

  rv = _strjoin_aux(args, ap);

  va_end(ap);
  return rv;
}

char* srcinst_fnjoin(char* str1, char* str2) {
  size_t len1, len2; char* p;

  len1 = strlen(str1); len2 = strlen(str2);
  if (!(p = malloc(len1 + len2 + 2))) {
    srcinst_error(SRCINST_ERR_HEAP, "filename join failed", 0);
  }

  strcpy(p, str1); p[len1] = '/'; strcpy(p + len1 + 1, str2);
  return p;
}

/* append to a heap-allocated string */

char* srcinst_append(char* p, char* s) {
  size_t len_p, len_s;

  if (!p)
    return srcinst_strdup(s);

  len_p = strlen(p); len_s = strlen(s) + 1;
  p = srcinst_realloc(p, len_p + len_s);
  memcpy(p + len_p, s, len_s);
  return p;
}

#undef STRJOIN_MAX



